"use strict";

var p4map = [
  '//depot/v70.2/patty/... patty/...',
  '//depot/main/tools/build/bin/... tools/build/bin/...',
  '//depot/main/tools/build/conf/build.conf tools/build/conf/build.conf',
  '//depot/main/tools/build/conf/mozartsuite/... tools/build/conf/mozartsuite/...',
  '//depot/main/tools/build/lib/perl/CPAN/... tools/build/lib/perl/CPAN/...',
  '//depot/main/tools/build/lib/perl/PATTY/... tools/build/lib/perl/PATTY/...',
  '//project1/mozart/v72.2/... ...',
  '-//project1/mozart/v72.2/patty/Jamrules patty/Jamrules',
  '-//project1/mozart/v72.2/patty/auth/... patty/auth/...',
  '-//project1/mozart/v72.2/patty/broker/... patty/broker/...',
  '-//project1/mozart/v72.2/patty/dbopen2/... patty/dbopen2/...',
  '-//project1/mozart/v72.2/patty/dbpipe/... patty/dbpipe/...',
  '-//project1/mozart/v72.2/patty/dma/... patty/dma/...',
  '-//project1/mozart/v72.2/patty/dmc/... patty/dmc/...',
  '-//project1/mozart/v72.2/patty/dmi/... patty/dmi/...',
  '-//project1/mozart/v72.2/patty/dml/... patty/dml/...',
  '-//project1/mozart/v72.2/patty/dmp/... patty/dmp/...',
  '-//project1/mozart/v72.2/patty/dmr/... patty/dmr/...',
  '-//project1/mozart/v72.2/patty/dmrpc/... patty/dmrpc/...',
  '-//project1/mozart/v72.2/patty/dms/... patty/dms/...',
  '-//project1/mozart/v72.2/patty/dmx/... patty/dmx/...',
  '-//project1/mozart/v72.2/patty/lbr/... patty/lbr/...',
  '-//project1/mozart/v72.2/patty/proxy/... patty/proxy/...',
  '-//project1/mozart/v72.2/patty/server/... patty/server/...',
  '-//project1/mozart/v72.2/patty/tests/... patty/tests/...',
  '//project1/mozart/v72.2/tools/build/bin/relnotes.pl tools/build/bin/relnotes.pl',
  '//project1/mozart/v72.2/tools/build/bin/artwork-macosx tools/build/bin/artwork-macosx',
  '//project1/mozart/v72.2/tools/build/bin/macosx tools/build/bin/macosx',
  '//3rd_party/cpp_libraries/project1/5.15.1/archive/project1-license.txt project1/.project1-license',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.centos74x86_64/release-shared/... project1/linux26x86_64/release-shared/...',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.macosx1015x86_64/debug-shared/... project1/macosx1015x86_64/debug-shared/...',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.macosx1015x86_64/release-shared/... project1/macosx1015x86_64/release-shared/...',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.ntx64/vs15/debug-shared/... project1/ntx64/debug-shared/...',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.ntx64/vs15/release-shared/... project1/ntx64/release-shared/...',
  '//3rd_party/cpp_libraries/project1/5.15.1/lib.ntx86/vs15/release-shared/... project1/ntx86/release-shared/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/inc.linux26x86_64/... ssl/linux26x86_64/include/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.linux26x86_64/shared/... ssl/linux26x86_64/lib/shared/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.linux26x86_64/%%1.a ssl/linux26x86_64/lib/static/%%1.a',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/inc.macosx1013x86_64/... ssl/macosx1015x86_64/include/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.macosx1013x86_64/shared/... ssl/macosx1015x86_64/lib/shared/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.macosx1013x86_64/%%1.a ssl/macosx1015x86_64/lib/static/%%1.a',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/inc.ntx64/... ssl/ntx64/include/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx64/vs15/dyn/shared/%%1 ssl/ntx64/lib/shared/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx64/vs15/dyn/d/shared/%%1 ssl/ntx64/lib/shared/d/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx64/vs15/%%1 ssl/ntx64/lib/static/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx64/vs15/d/%%1 ssl/ntx64/lib/static/d/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/inc.ntx86/... ssl/ntx86/include/...',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx86/vs15/dyn/shared/%%1 ssl/ntx86/lib/shared/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx86/vs15/dyn/d/shared/%%1 ssl/ntx86/lib/shared/d/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx86/vs15/%%1 ssl/ntx86/lib/static/%%1',
  '//3rd_party/cpp_libraries/openssl/1.1.1-latest/lib.ntx86/vs15/d/%%1 ssl/ntx86/lib/static/d/%%1',
  '//3rd_party/compilers/clang/6.0.0/bin.darwin90x86_64/lib/libc++.1.0.dylib clang/macosx1015x86_64/lib/libc++.1.dylib',
  '//3rd_party/compilers/clang/6.0.0/bin.darwin90x86_64/lib/libc++abi.1.0.dylib clang/macosx1015x86_64/lib/libc++abi.1.dylib',
  '//3rd_party/cpp_libraries/icu/68.1/include/... icu/include/...',
  '//3rd_party/cpp_libraries/icu/68.1/lib.centos74x86_64/release-shared/... icu/linux26x86_64/release-shared/...',
  '//3rd_party/cpp_libraries/icu/68.1/lib.ntx64/vs15.7/release-shared/... icu/ntx64/release-shared/...',
  '//3rd_party/cpp_libraries/icu/68.1/lib.ntx86/vs15.7/release-shared/... icu/ntx86/release-shared/...'
];

var resultmap = [];

async function showResult() {
  try {
    var mapTable = document.getElementById("listMap");

    while (mapTable.hasChildNodes()) {
      mapTable.removeChild(mapTable.firstChild);
    }

    var index = 0;
    resultmap.forEach(line => {
      var row = mapTable.insertRow(index++);
      var cell = row.insertCell(0);
      var textNode = document.createTextNode(line);
      cell.appendChild(textNode);
    });
  }
  catch (e) {
    alert(e);
  }
}

async function runOnload() {
  await reset();
}

async function reset() {
  resultmap = p4map;
  showResult();
}

async function testLeft() {
  p4vjs.mapLeft(p4map).then(function(result) {
    resultmap = result;
    showResult();
  });
}

async function testRight() {
  p4vjs.mapRight(p4map).then(function(result) {
    resultmap = result;
    showResult();
  });
}

async function testReverse() {
  p4vjs.mapReverse(p4map).then(function(result) {
    resultmap = result;
    showResult();
  });
}