/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.jersey.jaxb.internal.AbstractJaxbElementProvider;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;

public class JettisonJaxbElementProvider
extends AbstractJaxbElementProvider {
    JettisonJaxbElementProvider(Providers ps) {
        super(ps);
    }

    JettisonJaxbElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(type, genericType, annotations, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type, genericType, annotations, mediaType);
    }

    @Override
    protected final JAXBElement<?> readFrom(Class<?> type, MediaType mediaType, Unmarshaller unmarshaller, InputStream entityStream) throws JAXBException {
        Charset c = JettisonJaxbElementProvider.getCharset(mediaType);
        return JettisonJaxbContext.getJSONUnmarshaller(unmarshaller).unmarshalJAXBElementFromJSON(new InputStreamReader(entityStream, c), type);
    }

    @Override
    protected final void writeTo(JAXBElement<?> t2, MediaType mediaType, Charset c, Marshaller m4, OutputStream entityStream) throws JAXBException {
        JettisonMarshaller jsonMarshaller = JettisonJaxbContext.getJSONMarshaller(m4);
        if (this.isFormattedOutput()) {
            jsonMarshaller.setProperty("org.glassfish.jersey.media.json.JsonMarshaller.formatted", true);
        }
        jsonMarshaller.marshallToJSON(t2, new OutputStreamWriter(entityStream, c));
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonJaxbElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }

        @Override
        protected boolean isSupported(MediaType m4) {
            return m4.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonJaxbElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_JSON_TYPE);
        }
    }
}

