/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.server;

import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.RequestException;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.RequestHandler;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.DescriptionResponse;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.ErrorResponse;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.FieldResponse;
import com.perforce.p4dtg.plugin.jira.tcp.request.IRequestHandler;
import com.perforce.p4dtg.plugin.jira.tcp.response.IResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TcpSocketServer {
    private static final Logger logger = Logger.getLogger(TcpSocketServer.class.getPackage().getName());
    private static final boolean DUMP_TRAFFIC = new Boolean(System.getProperty("javadts.DUMP_TRAFFIC"));
    private final Charset charset = Charset.forName("UTF-8");
    private static int socketTimeout = 30000;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private IRequestHandler handler;
    private boolean shutdown = false;

    public TcpSocketServer(IRequestHandler handler) {
        this.handler = handler;
    }

    private DocumentBuilder createParser() {
        DocumentBuilder parser = null;
        try {
            parser = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Error creating new document parser.", e);
        }
        return parser;
    }

    private Document getRequest(InputStream stream) {
        DataInputStream is = new DataInputStream(stream);
        Document request = null;
        DocumentBuilder parser = this.createParser();
        if (parser != null) {
            try {
                StringBuilder readLength = new StringBuilder();
                int read = stream.read();
                while (read != 60 && read != -1) {
                    readLength.append((char)read);
                    read = stream.read();
                }
                if (readLength.length() > 0) {
                    int expectedLength;
                    int length = expectedLength = Integer.parseInt(readLength.toString());
                    byte[] byteRequest = new byte[length];
                    byteRequest[0] = 60;
                    is.readFully(byteRequest, 1, --length);
                    int totalRead = byteRequest.length;
                    if (totalRead != expectedLength) {
                        logger.severe("Expected message of size: " + expectedLength + " but received: " + totalRead);
                    }
                    if (DUMP_TRAFFIC) {
                        String reqTag = new String(byteRequest);
                        if (reqTag.startsWith("<LOGIN JIRA_URL=")) {
                            reqTag = reqTag.replaceAll("JIRA_PASSWORD=\"(.*?)\" />", "JIRA_PASSWORD=\"*****\" />");
                        }
                        logger.info("Request: " + reqTag);
                    }
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(byteRequest);
                    request = parser.parse(byteStream);
                }
            }
            catch (SAXException e) {
                logger.log(Level.SEVERE, "XML parser exception reading request.", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "I/O exception reading from stream.", e);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Number format exception parsing message length.", e);
            }
        }
        return request;
    }

    private IResponse wrapResponseArray(IResponse[] responses, String outerElmement) {
        IResponse response = null;
        if (responses != null && outerElmement != null) {
            final StringBuilder xml = new StringBuilder();
            xml.append('<');
            xml.append(outerElmement);
            xml.append('>');
            for (IResponse inner : responses) {
                if (inner == null) continue;
                xml.append(inner.toString());
            }
            xml.append("</");
            xml.append(outerElmement);
            xml.append('>');
            response = new IResponse(){

                @Override
                public String toString() {
                    return xml.toString();
                }
            };
        }
        return response;
    }

    private IResponse wrapFieldResponses(FieldResponse[] responses) {
        return this.wrapResponseArray(responses, "FIELDS");
    }

    private IResponse wrapDescriptionResponses(DescriptionResponse[] responses) {
        return this.wrapResponseArray(responses, "DESCS");
    }

    private Request getRequestType(Document request) {
        Request requestType = null;
        Element root = request.getDocumentElement();
        if (root != null) {
            String rootTag = root.getTagName();
            requestType = Request.valueOf(rootTag);
        }
        return requestType;
    }

    private String getResponse(Document request) {
        IResponse response = null;
        Element root = request.getDocumentElement();
        if (root != null) {
            String rootTag = root.getTagName();
            try {
                Request requestType = Request.valueOf(rootTag);
                try {
                    switch (requestType) {
                        case SHUTDOWN: {
                            response = this.handler.shutdown(root);
                            break;
                        }
                        case CONNECT: {
                            response = this.handler.connect(root);
                            break;
                        }
                        case LOGIN: {
                            response = this.handler.login(root);
                            break;
                        }
                        case PING: {
                            response = this.handler.ping(root);
                            break;
                        }
                        case LIST_PROJECTS: {
                            response = this.handler.listProjects(root);
                            break;
                        }
                        case GET_PROJECT: {
                            response = this.handler.getProject(root);
                            break;
                        }
                        case GET_SERVER_VERSION: {
                            response = this.handler.getServerVersion(root);
                            break;
                        }
                        case GET_SERVER_DATE: {
                            response = this.handler.getServerDate(root);
                            break;
                        }
                        case LIST_FIELDS: {
                            response = this.wrapDescriptionResponses(this.handler.listFields(root));
                            break;
                        }
                        case LIST_DEFECTS: {
                            response = this.handler.listDefects(root);
                            break;
                        }
                        case CREATE_DEFECT: {
                            response = this.handler.createDefect(root);
                            break;
                        }
                        case NEW_DEFECT: {
                            response = this.wrapFieldResponses(this.handler.newDefect(root));
                            break;
                        }
                        case SEGMENT_FILTERS: {
                            response = this.handler.getSegmentFilters(root);
                        }
                        case REFERENCED_FIELDS: {
                            response = this.handler.getReferencedFields(root);
                            break;
                        }
                        case SAVE_DEFECT: {
                            response = this.handler.saveDefect(root);
                            break;
                        }
                        case GET_DEFECT: {
                            response = this.wrapFieldResponses(this.handler.getDefect(root));
                            break;
                        }
                        default: {
                            response = new ErrorResponse("Unhandled element name in request: " + rootTag, "0");
                            break;
                        }
                    }
                }
                catch (RequestException e) {
                    response = e.getResponse();
                }
                catch (Throwable e) {
                    response = new ErrorResponse("Error occurred while processing request: " + e.getLocalizedMessage(), "0");
                }
            }
            catch (IllegalArgumentException e) {
                response = new ErrorResponse("Unknown element name in request: " + rootTag, "0");
            }
        }
        return response != null ? response.toString() : null;
    }

    public void start(int port) throws Exception {
        this.start(null, port);
    }

    private void handle(Socket socket) throws Exception {
        InputStream incoming = null;
        OutputStream outgoing = null;
        try {
            incoming = socket.getInputStream();
            Document request = this.getRequest(incoming);
            while (request != null) {
                Request requestType;
                String response = this.getResponse(request);
                if (response == null) {
                    break;
                }
                outgoing = socket.getOutputStream();
                byte[] byteResponse = response.getBytes(this.charset);
                outgoing.write(Integer.toString(byteResponse.length).getBytes(this.charset));
                outgoing.write(byteResponse);
                outgoing.flush();
                if (DUMP_TRAFFIC) {
                    logger.info("Response length: " + byteResponse.length);
                    logger.info("Response: " + response);
                }
                if ((requestType = this.getRequestType(request)) == Request.SHUTDOWN) {
                    this.shutdown = true;
                    break;
                }
                request = this.getRequest(incoming);
                if (request != null) continue;
                logger.severe("Unable to parse request.");
                ErrorResponse er = new ErrorResponse("Unable to parse the request.", "0");
                byteResponse = er.toString().getBytes(this.charset);
                outgoing.write(Integer.toString(byteResponse.length).getBytes(this.charset));
                outgoing.write(byteResponse);
                outgoing.flush();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Problem occurred while handling request.", e);
            throw new Exception(e);
        }
        finally {
            if (outgoing != null) {
                try {
                    outgoing.flush();
                    outgoing.close();
                }
                catch (IOException request) {}
            }
            if (incoming != null) {
                try {
                    incoming.close();
                }
                catch (IOException request) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InetAddress address, int port) throws Exception {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, address);
            socket.setSoTimeout(socketTimeout);
            logger.log(Level.INFO, "Socket timeout is set to (milliseconds): " + socketTimeout);
            Socket incoming = socket.accept();
            while (incoming != null) {
                block20: {
                    block21: {
                        try {
                            if (DUMP_TRAFFIC) {
                                logger.info("Starting connection.");
                            }
                            this.handle(incoming);
                            if (!this.shutdown) break block20;
                            if (DUMP_TRAFFIC) {
                                logger.info("Shutdown request has been called.");
                            }
                            if (!DUMP_TRAFFIC) break block21;
                            logger.info("Closing connection.");
                        }
                        catch (Throwable e) {
                            try {
                                logger.log(Level.SEVERE, "Problem handling incoming connection.", e);
                                break;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (DUMP_TRAFFIC) {
                                    logger.info("Closing connection.");
                                }
                                incoming.close();
                            }
                        }
                    }
                    incoming.close();
                    break;
                }
                if (DUMP_TRAFFIC) {
                    logger.info("Closing connection.");
                }
                incoming.close();
                incoming = socket.accept();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Problem occurred while handling socket connection.", e);
            throw new Exception(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException incoming) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            logger.severe("Must enter the properties file as a parameter.");
            System.exit(1);
        }
        File propFile = null;
        FileInputStream fis = null;
        try {
            propFile = new File(args[0]);
            if (propFile == null || !propFile.exists()) {
                logger.severe("Properties file: " + args[0] + " does not exist.");
                System.exit(1);
            }
            if ((fis = new FileInputStream(propFile)) != null) {
                Properties properties = new Properties();
                properties.load(fis);
                String tcpPort = properties.getProperty("tcp_port");
                String configFile = properties.getProperty("config_file");
                String defectBatch = properties.getProperty("defect_batch");
                RequestHandler handler = new RequestHandler();
                handler.setConfigFile(configFile);
                handler.setDefectBatch(defectBatch);
                TcpSocketServer dts = new TcpSocketServer(handler);
                dts.start(Integer.parseInt(tcpPort));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred.", e);
        }
        catch (Error e) {
            logger.log(Level.SEVERE, "Error occurred.", e);
        }
        catch (Throwable t2) {
            logger.log(Level.SEVERE, "Problem occurred.", t2);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable e) {}
            }
            if (propFile != null && propFile.exists()) {
                try {
                    propFile.delete();
                }
                catch (Throwable e) {}
            }
        }
        System.exit(0);
    }

    static {
        String socketTimeoutValue = System.getProperty("javadts.SOCKET_TIMEOUT");
        if (!Utils.isEmpty(socketTimeoutValue)) {
            try {
                int timeout = Integer.parseInt(socketTimeoutValue);
                if (timeout > 0) {
                    socketTimeout = timeout;
                }
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public static enum Request {
        SHUTDOWN,
        CONNECT,
        LOGIN,
        PING,
        LIST_PROJECTS,
        GET_PROJECT,
        GET_SERVER_VERSION,
        GET_SERVER_DATE,
        LIST_FIELDS,
        LIST_DEFECTS,
        CREATE_DEFECT,
        NEW_DEFECT,
        SEGMENT_FILTERS,
        REFERENCED_FIELDS,
        SAVE_DEFECT,
        GET_DEFECT;

    }
}

