/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.response;

import com.perforce.p4dtg.plugin.jira.tcp.internal.response.ResponseHelper;
import com.perforce.p4dtg.plugin.jira.tcp.response.IResponse;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class StringResponse
implements IResponse {
    private Set<String> values = new LinkedHashSet<String>();

    public StringResponse() {
    }

    public StringResponse(String value) {
        this();
        if (value != null) {
            this.values.add(value);
        }
    }

    public StringResponse(String[] values) {
        this();
        if (values != null) {
            for (String value : values) {
                this.add(value);
            }
        }
    }

    public StringResponse(Collection<String> values) {
        this();
        if (values != null) {
            for (String value : values) {
                this.add(value);
            }
        }
    }

    public void add(String value) {
        if (value != null) {
            this.values.add(value);
        }
    }

    public void remove(String value) {
        if (value != null) {
            this.values.remove(value);
        }
    }

    public void clear() {
        this.values.clear();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder xml = new StringBuilder();
        xml.append('<');
        xml.append("STRINGS");
        xml.append('>');
        for (String value : this.values) {
            xml.append('<');
            xml.append("STRING");
            xml.append(' ');
            xml.append("VALUE");
            xml.append('=');
            xml.append('\"');
            xml.append(ResponseHelper.escapeXML(value));
            xml.append('\"');
            xml.append(" />");
        }
        xml.append("</");
        xml.append("STRINGS");
        xml.append('>');
        return xml.toString();
    }
}

