/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.response;

import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.DescriptionResponse;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatusResolutionFieldsResponseBuilder {
    private Configuration configuration;
    private Map<String, String> statusesMap;
    private Map<String, String> resolutionsMap;

    public StatusResolutionFieldsResponseBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public DescriptionResponse build() {
        if (this.statusesMap != null) {
            String statusName;
            DescriptionResponse desc = null;
            LinkedHashMap<String, String> statusResolutionMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> stutusEntry : this.statusesMap.entrySet()) {
                statusName = stutusEntry.getKey();
                if (statusName == null) continue;
                statusResolutionMap.put(statusName, statusName);
            }
            if (this.resolutionsMap != null) {
                for (Map.Entry<String, String> statusEntry : this.statusesMap.entrySet()) {
                    statusName = statusEntry.getKey();
                    if (statusName == null || !this.exists(statusName)) continue;
                    for (Map.Entry<String, String> resolutionEntry : this.resolutionsMap.entrySet()) {
                        if (resolutionEntry == null || resolutionEntry.getKey() == null) continue;
                        String statusResolution = statusName + "/" + resolutionEntry.getKey();
                        if (statusResolutionMap.containsKey(statusName)) {
                            statusResolutionMap.remove(statusName);
                        }
                        statusResolutionMap.put(statusResolution, statusResolution);
                    }
                }
            }
            if (statusResolutionMap != null && !statusResolutionMap.isEmpty()) {
                desc = new DescriptionResponse("Status/Resolution", "SELECT", 0, statusResolutionMap.keySet().toArray(new String[statusResolutionMap.keySet().size()]));
            }
            return desc;
        }
        return null;
    }

    private boolean exists(String status) {
        Map<String, String> resolutionStatusMap;
        Map<String, Map<String, String>> workflowMap;
        return status != null && this.configuration != null && (workflowMap = this.configuration.getWorkflowMap()) != null && (resolutionStatusMap = workflowMap.get("resolutionStatus")) != null && resolutionStatusMap.containsValue(status);
    }

    public void setStatusesMap(Map<String, String> statusesMap) {
        this.statusesMap = statusesMap;
    }

    public void setResolutionsMap(Map<String, String> resolutionsMap) {
        this.resolutionsMap = resolutionsMap;
    }
}

