/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.response;

import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.config.CustomField;
import com.perforce.p4dtg.plugin.jira.config.Option;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.DescriptionResponse;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CustomFieldsResponseBuilder {
    private Configuration configuration;
    private Map<String, String> customFieldsMap;

    public CustomFieldsResponseBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<DescriptionResponse> build() {
        if (this.customFieldsMap != null && this.configuration != null && this.configuration.getCustomFields() != null) {
            LinkedList<DescriptionResponse> descs = new LinkedList<DescriptionResponse>();
            for (Map.Entry<String, String> entry : this.customFieldsMap.entrySet()) {
                String name = entry.getValue();
                String type = "LINE";
                int access = 1;
                String[] values = null;
                if (name != null) {
                    for (CustomField cf : this.configuration.getCustomFields()) {
                        if (cf == null || cf.getName() == null || !cf.getName().trim().equalsIgnoreCase(name)) continue;
                        if (cf.getType() != null) {
                            if (cf.getType().trim().equalsIgnoreCase("WORD")) {
                                type = "WORD";
                            } else if (cf.getType().trim().equalsIgnoreCase("LINE")) {
                                type = "LINE";
                            } else if (cf.getType().trim().equalsIgnoreCase("TEXT")) {
                                type = "TEXT";
                            } else if (cf.getType().trim().equalsIgnoreCase("DATE")) {
                                type = "DATE";
                            } else if (cf.getType().trim().equalsIgnoreCase("SELECT")) {
                                type = "SELECT";
                                if (cf.getOptions() != null) {
                                    LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
                                    opts.put("<Empty>", "<Empty>");
                                    for (Option option : cf.getOptions()) {
                                        opts.put(option.getValue(), option.getValue());
                                    }
                                    values = opts.keySet().toArray(new String[opts.keySet().size()]);
                                }
                            }
                        }
                        if (cf.getAccess() == null) break;
                        if (cf.getAccess().trim().equalsIgnoreCase("RW")) {
                            access = 0;
                            break;
                        }
                        if (!cf.getAccess().trim().equalsIgnoreCase("RO")) break;
                        access = 1;
                        break;
                    }
                }
                descs.add(new DescriptionResponse(name, type, access, values));
            }
            return descs;
        }
        return null;
    }

    public void setCustomFieldsMap(Map<String, String> customFieldsMap) {
        this.customFieldsMap = customFieldsMap;
    }
}

