/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.domain.User;
import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.RequestHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserNameHelper {
    public static Configuration configuration;
    private static final Logger logger;

    public static void setConfiguration(Configuration configuration) {
        logger.log(Level.FINEST, "UserNameHelper userStyles: {0} ", configuration.getUserStyles());
        UserNameHelper.configuration = configuration;
    }

    public static String getUserValue(User user) {
        String[] userStyles;
        if (user == null) {
            return null;
        }
        String value = null;
        String[] stringArray = userStyles = configuration.getUserStyles();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String style;
            switch (style = stringArray[i]) {
                case "name": {
                    value = user.getName();
                    break;
                }
                case "email": {
                    value = user.getEmailAddress();
                    break;
                }
                case "emailshort": {
                    int atSign;
                    value = user.getEmailAddress();
                    if (value == null || (atSign = value.indexOf("@")) <= 1) break;
                    value = value.substring(0, atSign);
                    break;
                }
                case "displayname": {
                    value = user.getDisplayName();
                }
            }
            if (value != null) break;
        }
        return value;
    }

    public static void validateConfig(String[] userStyles, String[] stylesDefault) throws Exception {
        for (String style : userStyles) {
            boolean found = false;
            for (String string : stylesDefault) {
                if (!string.equals(style)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String msg = "User value '" + style + "' not in valid values " + stylesDefault;
            Exception ex = new Exception(msg);
            throw ex;
        }
    }

    static {
        logger = Logger.getLogger(RequestHandler.class.getPackage().getName());
    }
}

