/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.config.Step;
import com.perforce.p4dtg.plugin.jira.config.Transition;
import com.perforce.p4dtg.plugin.jira.config.Workflow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransitionStatusMatcher {
    private Configuration configuration;

    public TransitionStatusMatcher(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> lookupActions(String fromStatus, String toStatus) {
        if (fromStatus != null && toStatus != null && this.configuration != null && this.configuration.getWorkflows() != null) {
            HashMap<String, String> actionsMap = new HashMap<String, String>();
            List<Workflow> workflows = this.configuration.getWorkflows();
            if (workflows != null) {
                for (Workflow workflow : workflows) {
                    if (workflow == null) continue;
                    this.lookupSteps(fromStatus, toStatus, workflow.getSteps(), actionsMap);
                }
            }
            return actionsMap;
        }
        return null;
    }

    private void lookupSteps(String fromStatus, String toStatus, List<Step> steps, Map<String, String> actionsMap) {
        if (fromStatus != null && toStatus != null && steps != null && actionsMap != null) {
            for (Step step : steps) {
                if (step == null) continue;
                String linkedStatus = step.getLinkedStatus();
                List<Transition> transitions = step.getTransitions();
                if (linkedStatus == null || transitions == null || !linkedStatus.trim().equalsIgnoreCase(fromStatus)) continue;
                this.lookupTransitions(fromStatus, toStatus, transitions, actionsMap);
            }
        }
    }

    private void lookupTransitions(String fromStatus, String toStatus, List<Transition> transitions, Map<String, String> actionsMap) {
        if (fromStatus != null && toStatus != null && transitions != null && actionsMap != null) {
            for (Transition transition : transitions) {
                if (transition == null) continue;
                String tn = transition.getName();
                String dsn = transition.getDestinationStep();
                if (tn == null || dsn == null || !this.matchSteps(dsn, toStatus)) continue;
                actionsMap.put(tn, tn);
            }
        }
    }

    private boolean matchSteps(String stepName, String linkedStatus) {
        List<Workflow> workflows;
        if (stepName != null && linkedStatus != null && this.configuration != null && (workflows = this.configuration.getWorkflows()) != null) {
            for (Workflow workflow : workflows) {
                List<Step> steps;
                if (workflow == null || !this.matchLinkedStatus(stepName, linkedStatus, steps = workflow.getSteps())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchLinkedStatus(String stepName, String linkedStatus, List<Step> steps) {
        if (stepName != null && linkedStatus != null && steps != null) {
            for (Step step : steps) {
                if (step == null) continue;
                String sn = new String(step.getName());
                String ls = new String(step.getLinkedStatus());
                if (sn == null || ls == null || !sn.trim().equalsIgnoreCase(stepName) || !ls.trim().equalsIgnoreCase(linkedStatus)) continue;
                return true;
            }
        }
        return false;
    }
}

