/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.perforce.p4dtg.plugin.jira.common.Constants;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SegmentFilterTranslator {
    static Logger logger = Logger.getLogger(SegmentFilterTranslator.class.getPackage().getName());
    private String segmentFilter = null;
    private Map<String, String> customFieldsMap = null;
    private Map<String, String> issueTypesMap = null;
    private Map<String, String> statusesMap = null;
    private Map<String, String> resolutionsMap = null;
    private Map<String, String> prioritiesMap = null;

    public String translate() {
        if (this.segmentFilter != null) {
            String target = "";
            String replace = "";
            try {
                String id;
                for (Map.Entry<String, String> entry : Constants.ISSUE_FIELDS.entrySet()) {
                    String string = entry.getKey();
                    id = entry.getValue();
                    target = string + "=";
                    replace = id + "=";
                    this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                }
                if (this.customFieldsMap != null) {
                    Iterator<Map.Entry<String, String>> sortedMap = new TreeMap(new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            int lenDiff = s2.length() - s1.length();
                            if (lenDiff != 0) {
                                return lenDiff;
                            }
                            return s1.compareTo(s2);
                        }
                    });
                    sortedMap.putAll(this.customFieldsMap);
                    for (Map.Entry entry : sortedMap.entrySet()) {
                        String name2 = (String)entry.getValue();
                        target = name2 + "=";
                        replace = "\"" + this.escapeFieldName(name2) + "\"=";
                        this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                    }
                }
                if (this.issueTypesMap != null) {
                    for (Map.Entry<String, String> entry : this.issueTypesMap.entrySet()) {
                        String string = (String)entry.getKey();
                        id = entry.getValue();
                        target = Constants.ISSUE_FIELDS.get("Issue Type") + "='" + string + "'";
                        replace = Constants.ISSUE_FIELDS.get("Issue Type") + "=\"" + id + "\"";
                        this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                    }
                }
                if (this.statusesMap != null) {
                    for (Map.Entry<String, String> entry : this.statusesMap.entrySet()) {
                        String string = entry.getKey();
                        id = entry.getValue();
                        target = Constants.ISSUE_FIELDS.get("Status") + "='" + string + "'";
                        replace = Constants.ISSUE_FIELDS.get("Status") + "=\"" + id + "\"";
                        this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                    }
                }
                if (this.resolutionsMap != null) {
                    for (Map.Entry<String, String> entry : this.resolutionsMap.entrySet()) {
                        String string = entry.getKey();
                        id = entry.getValue();
                        target = Constants.ISSUE_FIELDS.get("Resolution") + "='" + string + "'";
                        replace = Constants.ISSUE_FIELDS.get("Resolution") + "=\"" + id + "\"";
                        this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                    }
                }
                if (this.prioritiesMap != null) {
                    for (Map.Entry<String, String> entry : this.prioritiesMap.entrySet()) {
                        String string = entry.getKey();
                        id = entry.getValue();
                        target = Constants.ISSUE_FIELDS.get("Priority") + "='" + string + "'";
                        replace = Constants.ISSUE_FIELDS.get("Priority") + "=\"" + id + "\"";
                        this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
                    }
                }
                target = "='<Empty>'";
                replace = " is EMPTY";
                this.segmentFilter = this.segmentFilter.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replace));
            }
            catch (PatternSyntaxException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.segmentFilter == null ? null : this.segmentFilter.trim();
    }

    private String escapeFieldName(String fieldName) {
        if (fieldName != null) {
            return fieldName.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")).replaceAll(Pattern.quote("\""), Matcher.quoteReplacement("\\\""));
        }
        return fieldName;
    }

    public void setSegmentFilter(String segmentFilter) {
        this.segmentFilter = segmentFilter;
    }

    public void setCustomFieldsMap(Map<String, String> customFieldsMap) {
        this.customFieldsMap = customFieldsMap;
    }

    public void setIssueTypesMap(Map<String, String> issueTypesMap) {
        this.issueTypesMap = issueTypesMap;
    }

    public void setStatusesMap(Map<String, String> statusesMap) {
        this.statusesMap = statusesMap;
    }

    public void setResolutionsMap(Map<String, String> resolutionsMap) {
        this.resolutionsMap = resolutionsMap;
    }

    public void setPrioritiesMap(Map<String, String> prioritiesMap) {
        this.prioritiesMap = prioritiesMap;
    }
}

