/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.perforce.p4dtg.plugin.jira.common.Constants;
import com.perforce.p4dtg.plugin.jira.common.TimeCommand;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.rest.client.RestClientManager;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchRestClient;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchResult;
import com.perforce.p4dtg.plugin.jira.rest.internal.search.JqlSearcher;
import com.perforce.p4dtg.plugin.jira.rest.search.SearchService;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.AbstractRequestHandler;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.DefaultDefectFieldsMapBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.DefectFieldsMapBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.DefectFieldsTranslator;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueFieldsMapper;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueInputFieldsBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.JqlSearchBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.RequestException;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.SegmentFilterTranslator;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.CustomFieldsResponseBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.DefectFieldsResponseBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.DescriptionResponse;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.ErrorResponse;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.FieldResponse;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.StatusResolutionFieldsResponseBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.StringResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequestHandler
extends AbstractRequestHandler {
    private static final Logger logger = Logger.getLogger(RequestHandler.class.getPackage().getName());
    private static final boolean DUMP_DEBUG = Boolean.valueOf(System.getProperty("javadts.DUMP_DEBUG"));
    private static boolean QUERY_LEGACY = false;
    private static final Map<String, String> IGNORE_PROJECTS = new HashMap<String, String>();
    private RestClientManager restClientManager;
    private SearchService searchService;
    private IssueFieldsMapper issueFieldsMapper;
    private String jiraServerUrl;
    private String jiraUsername;
    private String jiraPassword;
    private int queryBatchSize = 100;
    private String defectBatch;
    private String segmentFilter;
    private String projectList;
    private String configFile;
    private Configuration configuration;
    private ServerInfo serverInfo = null;
    private static final Map<String, Project> PROJECT_CACHE = new HashMap<String, Project>();
    private static final Map<String, User> USER_CACHE = new HashMap<String, User>();
    private static final List<String> ALL_PROJECT_KEYS = new ArrayList<String>();
    private static int GET_PROJECT_COUNT = 0;
    private static final Integer LOCK_GET_PROJECT_COUNT = 0;
    private static final Map<String, Integer> PROJECT_ACCESS_CACHE = new HashMap<String, Integer>();
    private String projMessage = ".";
    private final TimeCommand projTimer = new TimeCommand();
    private static final int BAD_RESULT_CODE = 201;

    public void setLogLevel(Level level) {
        Handler[] handlers;
        logger.setLevel(level);
        for (Handler handler : handlers = logger.getHandlers()) {
            handler.setLevel(level);
        }
    }

    public void setJiraServerUrl(String jiraServerUrl) {
        this.jiraServerUrl = jiraServerUrl;
    }

    public void setJiraUsername(String jiraUsername) {
        this.jiraUsername = jiraUsername;
    }

    public void setJiraPassword(String jiraPassword) {
        this.jiraPassword = jiraPassword;
    }

    public void setDefectBatch(String defectBatch) {
        this.defectBatch = defectBatch;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public RequestHandler() {
        if (DUMP_DEBUG) {
            Handler[] handlers;
            logger.info("Setting logging level to FINEST");
            logger.setLevel(Level.FINEST);
            for (Handler handler : handlers = logger.getHandlers()) {
                handler.setLevel(Level.FINEST);
            }
        }
    }

    public void initialize() throws Exception {
        String ignore;
        if (this.jiraServerUrl == null) {
            throw new Exception("The jiraServerUrl is null.");
        }
        if (this.jiraUsername == null) {
            throw new Exception("The jiraUsername is null.");
        }
        if (this.jiraPassword == null) {
            throw new Exception("The jiraPassword is null.");
        }
        this.initRestClientManager();
        this.initConfig();
        this.initDefectBatch();
        this.issueFieldsMapper = new IssueFieldsMapper(this.restClientManager, this.configuration);
        this.searchService = new JqlSearcher(this.restClientManager);
        QUERY_LEGACY = "2014.1".equals(this.configuration.getJiraHandling("QueryStyle"));
        if (QUERY_LEGACY) {
            logger.info("Using QueryStyle 2014.1");
        }
        if ((ignore = this.configuration.getJiraHandling("IgnoreProjects")) != null && ignore.length() > 0) {
            String[] projs = ignore.split(",");
            StringBuilder sb = new StringBuilder();
            for (String proj : projs) {
                if (proj.length() < 1) continue;
                IGNORE_PROJECTS.put(proj, proj);
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(proj);
            }
            logger.log(Level.INFO, "Ignored Projects: {0}", sb);
        }
        if (IGNORE_PROJECTS.size() < 1) {
            logger.log(Level.INFO, "Ignored Projects: none");
        }
    }

    private void initConfig() throws Exception {
        this.configuration = new Configuration(this.configFile);
        this.configuration.parse();
        logger.log(Level.INFO, "Configuration loaded from {0}", this.configuration.getXmlFile());
        logger.finer(this.configuration.toString());
    }

    private void initDefectBatch() {
        if (this.defectBatch != null) {
            try {
                int size = Integer.parseInt(this.defectBatch);
                if (size > 0) {
                    this.queryBatchSize = size;
                }
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "defect Batch value ''{0}'' invalid: {1}", new Object[]{this.defectBatch, e.getMessage()});
            }
        }
        logger.log(Level.INFO, "JIRA query batch size is set to: {0}", this.queryBatchSize);
    }

    private void initRestClientManager() throws Exception {
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        this.restClientManager = new RestClientManager(this.jiraServerUrl, this.jiraUsername, this.jiraPassword);
        if (this.restClientManager == null) {
            throw new Exception("Error occurred while connecting to the JIRA server: rest client manager initialization error.");
        }
        if (logger.isLoggable(Level.FINER)) {
            qMsg = "initRestClientManager: getServerInfo";
            RequestHandler.logStart(qMsg, timer);
        }
        if (this.restClientManager.getExtendedMetadataClient().getServerInfo().claim().getBuildNumber() < 700) {
            throw new Exception("This DTG JIRA plugin only support JIRA server version 5 or greater.");
        }
        if (logger.isLoggable(Level.FINER)) {
            RequestHandler.logStop(qMsg, timer);
        }
    }

    @Override
    public String getId() throws RequestException {
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        if (this.serverInfo == null) {
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "getId;  getServerInfo()";
                RequestHandler.logStart(qMsg, timer);
            }
            this.serverInfo = this.restClientManager.getExtendedMetadataClient().getServerInfo().claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        if (this.serverInfo != null) {
            return this.serverInfo.getVersion();
        }
        return "";
    }

    @Override
    public StringResponse createDefect(Element request) throws RequestException {
        Map<String, String[]> statusResolutionFields;
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        String projId = this.getFieldValue(request, "PROJID");
        if (projId == null) {
            throw new RequestException(new ErrorResponse("Missing PROJID in createDefect", "0"));
        }
        if (projId.equalsIgnoreCase("*All*")) {
            throw new RequestException(new ErrorResponse("Invalid PROJID in newDefect", "0"));
        }
        Project project = null;
        try {
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "createDefect:  getProject " + projId;
                RequestHandler.logStart(qMsg, timer);
            }
            project = this.restClientManager.getProjectClient().getProject(projId).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving project: " + projId + " :" + e.toString(), "0"));
        }
        if (project == null) {
            throw new RequestException(new ErrorResponse("Defect requested for unknown project: " + projId, "0"));
        }
        Map<String, String[]> defectFields = this.getDefectFields(request);
        if (defectFields.containsKey("*Project*")) {
            defectFields.remove("*Project*");
        }
        IssueInputFieldsBuilder iifBuilder = new IssueInputFieldsBuilder(projId, defectFields, this.issueFieldsMapper, this.restClientManager);
        BasicIssue basicIssue = null;
        try {
            IssueInput issueInput = iifBuilder.build();
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "createDefect:  createIssue";
                RequestHandler.logStart(qMsg, timer);
            }
            basicIssue = this.restClientManager.getExtendedIssueClient().createIssue(issueInput).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while creating defect: " + e.toString(), "0"));
        }
        if (basicIssue == null) {
            throw new RequestException(new ErrorResponse("Unable to create defect", "0"));
        }
        if (logger.isLoggable(Level.FINER)) {
            qMsg = "createDefect:  getIssue";
            RequestHandler.logStart(qMsg, timer);
        }
        Issue issue = this.restClientManager.getExtendedIssueClient().getIssue(basicIssue.getKey()).claim();
        if (logger.isLoggable(Level.FINER)) {
            RequestHandler.logStop(qMsg, timer);
        }
        if (!this.issueFieldsMapper.isDifferentStatusResolution(issue, statusResolutionFields = this.issueFieldsMapper.getStatusResolutionMap(defectFields)) && defectFields.containsKey("Status")) {
            defectFields.remove("Status");
        }
        issue = this.updateIssueStatus(issue, defectFields);
        return new StringResponse(issue.getKey());
    }

    @Override
    public FieldResponse[] getDefect(Element request) throws RequestException {
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        String projId = request.getAttribute("PROJID");
        if (Utils.isEmpty(projId)) {
            throw new RequestException(new ErrorResponse("Missing PROJID in getDefect", "0"));
        }
        String defectId = request.getAttribute("DEFECT");
        if (Utils.isEmpty(defectId)) {
            throw new RequestException(new ErrorResponse("Missing DEFECT in getDefect", "0"));
        }
        Issue issue = null;
        try {
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "getDefect: getIssue " + defectId;
                RequestHandler.logStart(qMsg, timer);
            }
            issue = this.restClientManager.getExtendedIssueClient().getIssue(defectId).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving defect: " + defectId + " :" + e.toString(), "0"));
        }
        if (issue == null) {
            throw new RequestException(new ErrorResponse("Defect: " + defectId + " not found", "0"));
        }
        DefectFieldsMapBuilder dfmBuilder = new DefectFieldsMapBuilder(issue, this.issueFieldsMapper, this.configuration);
        Map<String, String[]> fieldValueMap = dfmBuilder.build();
        DefectFieldsResponseBuilder dfrBuilder = new DefectFieldsResponseBuilder();
        dfrBuilder.setFieldValueMap(fieldValueMap);
        FieldResponse[] fieldResponses = dfrBuilder.build();
        ArrayList<FieldResponse> fields = new ArrayList<FieldResponse>();
        fields.addAll(Arrays.asList(fieldResponses));
        fields.add(new FieldResponse("*Project*", issue.getProject().getKey()));
        return fields.toArray(new FieldResponse[fields.size()]);
    }

    @Override
    public StringResponse getProject(Element request) throws RequestException {
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        String name = request.getAttribute("PROJECT");
        if (name == null) {
            throw new RequestException(new ErrorResponse("Missing PROJECT in getProject", "0"));
        }
        if ("*All*".equalsIgnoreCase(name)) {
            return new StringResponse(name);
        }
        try {
            Project project = this.getProjectCached(name);
            if (project == null) {
                throw new RequestException(new ErrorResponse("Unknown project requested: " + name, "0"));
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving projec: " + name + " :" + e.toString(), "0"));
        }
        return new StringResponse(name);
    }

    private String getFieldValue(Element element, String field) {
        NodeList nl;
        if (element != null && field != null && (nl = element.getElementsByTagName("Field")) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                if (e == null || e.getAttribute("NAME") == null || !e.getAttribute("NAME").equalsIgnoreCase(field)) continue;
                return e.getAttribute("VALUE");
            }
        }
        return null;
    }

    public Map<String, String[]> getDefectFields(Element element) {
        if (element != null) {
            HashMap<String, String[]> nameValueMap = new HashMap<String, String[]>();
            NodeList nl = element.getElementsByTagName("Field");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element e = (Element)nl.item(i);
                    if (e == null) continue;
                    String name = e.getAttribute("NAME");
                    String value = e.getAttribute("VALUE");
                    if (name == null || value == null) continue;
                    nameValueMap.put(name, new String[]{value});
                }
            }
            return nameValueMap;
        }
        return null;
    }

    @Override
    public StringResponse listDefects(Element request) throws RequestException {
        String projId = request.getAttribute("PROJID");
        String date = request.getAttribute("DATE");
        String max = request.getAttribute("MAX");
        String modBy = request.getAttribute("MODBY");
        String modDate = request.getAttribute("MODDATE");
        String user = request.getAttribute("USER");
        if (projId == null) {
            throw new RequestException(new ErrorResponse("Missing PROJID in listDefects", "0"));
        }
        if (this.segmentFilter != null && this.segmentFilter.contains("(Status/Resolution=")) {
            throw new RequestException(new ErrorResponse("Segmentation on Status/Resolution field is not supported", "0"));
        }
        if (date != null) {
            try {
                date = Utils.formatDate(Utils.parseDate(date, "yyyy/MM/dd HH:mm:ss"), "yyyy/MM/dd HH:mm:ss");
            }
            catch (ParseException e) {
                throw new RequestException(new ErrorResponse("Invalid date", "0"));
            }
        }
        HashMap<String, String> allIssueKeys = new HashMap<String, String>();
        List<String> projectIds = this.getProjectList(projId, QUERY_LEGACY);
        if (QUERY_LEGACY || projectIds.size() == 1) {
            for (String projectId : projectIds) {
                Map<String, String> issueKeys;
                if (projectId == null || (issueKeys = this.queryDefects(projectId, null, date, max, modDate)) == null) continue;
                allIssueKeys.putAll(issueKeys);
            }
        } else {
            Map<String, String> issueKeys = this.queryDefects(null, projectIds, date, max, modDate);
            if (issueKeys != null) {
                allIssueKeys.putAll(issueKeys);
            }
        }
        return new StringResponse(allIssueKeys.keySet().toArray(new String[allIssueKeys.size()]));
    }

    private List<String> getProjectList(String projId, boolean legacy) throws RequestException {
        if (projId == null) {
            throw new RequestException(new ErrorResponse("Missing PROJID in listDefects", "0"));
        }
        List<String> projectIds = new ArrayList<String>();
        if (projId.equalsIgnoreCase("*All*")) {
            if (this.projectList != null && !this.projectList.equalsIgnoreCase("*All*")) {
                String[] projects;
                for (String project : projects = this.projectList.split(",")) {
                    if (project == null || !this.hasProjectAccess(project)) continue;
                    projectIds.add(project);
                }
                if (projectIds.isEmpty()) {
                    throw new RequestException(new ErrorResponse("The P4DTG User does not have access to any of the projects in the segment; must have one.", "0"));
                }
            } else if (legacy) {
                try {
                    projectIds = this.getAllProjectsCached();
                }
                catch (RestClientException e) {
                    logger.log(Level.SEVERE, e.toString(), e);
                    throw new RequestException(new ErrorResponse("Error occurred while retrieving all projects: " + e.toString(), "0"));
                }
            }
        } else {
            projectIds.add(projId);
        }
        return projectIds;
    }

    protected Map<String, String> queryDefects(String projId, List<String> projectIds, String date, String max, String modDate) throws RequestException {
        TimeCommand timer = new TimeCommand();
        Project project = null;
        if (projId != null) {
            try {
                project = this.getProjectCached(projId);
            }
            catch (RestClientException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                throw new RequestException(new ErrorResponse("Error occurred while retrieving project: " + projId + ": " + e.toString(), "0"));
            }
            if (project == null) {
                throw new RequestException(new ErrorResponse("Unknown project: " + projId, "0"));
            }
        }
        int limit = 0;
        if (max != null) {
            try {
                limit = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Exception parsing max issues limit '" + max + "'", e);
            }
        }
        if (limit <= 0) {
            limit = 200;
        }
        HashMap<String, String> issueKeys = new HashMap<String, String>();
        int maxBatchResults = this.queryBatchSize > limit ? limit : this.queryBatchSize;
        String query = null;
        JqlSearchBuilder jqlBuilder = new JqlSearchBuilder();
        try {
            jqlBuilder.setProjId(projId);
            if (projectIds != null) {
                jqlBuilder.setProjects(projectIds.toArray(new String[0]));
            }
            jqlBuilder.setDate(date);
            jqlBuilder.setModDate(modDate);
            jqlBuilder.setUserName(null);
            jqlBuilder.setSegmentFilter(this.segmentFilter);
            jqlBuilder.setOrderBy("ORDER BY key ASC");
            query = jqlBuilder.build();
            logger.log(Level.INFO, "Jira query with batch size ({0}): {1}", new Object[]{this.queryBatchSize, query});
            HashSet<String> fields = new HashSet<String>(Arrays.asList("-description", "-comment"));
            StringBuilder ignoredIssues = new StringBuilder();
            if (this.restClientManager.isJiraCloudURL()) {
                logger.log(Level.INFO, "Running Enhanced JQL ::queryDefects");
                P4DTGSearchRestClient p4DTGSearchRestClient = this.restClientManager.getSearchJqlClient();
                int cnt = maxBatchResults;
                int loopCnt = 0;
                String nextPageToken = null;
                while (cnt == maxBatchResults) {
                    String qMsg = "queryDefects:  Query " + ++loopCnt + " for project " + (projId != null ? projId : "multiple projects") + " since " + date;
                    if (logger.isLoggable(Level.FINER)) {
                        RequestHandler.logStart(qMsg, timer);
                    } else {
                        timer.start();
                    }
                    P4DTGSearchResult searchResult = p4DTGSearchRestClient.searchEnhancedJql(query, maxBatchResults, nextPageToken, fields).claim();
                    nextPageToken = searchResult.getNextPageToken();
                    if (logger.isLoggable(Level.INFO)) {
                        RequestHandler.logStop(qMsg, timer, Integer.toString(searchResult.getTotal()) + " issue(s)");
                    }
                    cnt = 0;
                    for (Issue issue : searchResult.getIssues()) {
                        ++cnt;
                        String issueProject = issue.getProject().getKey();
                        if (this.configuration.isIgnoredProject(issueProject)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            ignoredIssues.append(issue.getKey()).append(" ");
                            continue;
                        }
                        issueKeys.put(issue.getKey(), issue.getKey());
                    }
                }
            } else {
                SearchRestClient searchClient = this.restClientManager.getSearchClient();
                int cnt = maxBatchResults;
                int cntSoFar = 0;
                int loopCnt = 0;
                while (cnt == maxBatchResults) {
                    String qMsg = "queryDefects:  Query " + ++loopCnt + " for project " + (projId != null ? projId : "multiple projects") + " since " + date;
                    if (logger.isLoggable(Level.FINER)) {
                        RequestHandler.logStart(qMsg, timer);
                    } else {
                        timer.start();
                    }
                    SearchResult searchResult = searchClient.searchJql(query, maxBatchResults, cntSoFar, fields).claim();
                    if (logger.isLoggable(Level.INFO)) {
                        RequestHandler.logStop(qMsg, timer, Integer.toString(searchResult.getTotal()) + " issue(s)");
                    }
                    cnt = 0;
                    for (Issue issue : searchResult.getIssues()) {
                        ++cnt;
                        ++cntSoFar;
                        String issueProject = issue.getProject().getKey();
                        if (this.configuration.isIgnoredProject(issueProject)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            ignoredIssues.append(issue.getKey()).append(" ");
                            continue;
                        }
                        issueKeys.put(issue.getKey(), issue.getKey());
                    }
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                if (ignoredIssues.length() < 1) {
                    ignoredIssues.append("none.");
                }
                logger.log(Level.FINE, "Ignored issues: {0}", ignoredIssues);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving defects from project: " + projId + ", query = '" + query + "': " + e.toString(), "0"));
        }
        return issueKeys;
    }

    @Override
    public DescriptionResponse[] listFields(Element request) throws RequestException {
        String projId = request.getAttribute("PROJID");
        if (projId == null) {
            throw new RequestException(new ErrorResponse("Missing PROJID in listFields", "0"));
        }
        Map<String, String> issueTypesMap = this.issueFieldsMapper.getIssueTypesMap(projId);
        Map<String, String> prioritiesMap = this.issueFieldsMapper.getPrioritiesMap();
        Map<String, String> resolutionsMap = this.issueFieldsMapper.getResolutionsMap();
        Map<String, String> statusesMap = this.issueFieldsMapper.getStatusesMap();
        Map<String, String> customFieldsMap = this.issueFieldsMapper.getCustomFieldsMap();
        LinkedList<DescriptionResponse> descs = new LinkedList<DescriptionResponse>();
        descs.add(new DescriptionResponse("Issue Key", "WORD", 4, null));
        descs.add(new DescriptionResponse("Reporter", "WORD", 1, null));
        descs.add(new DescriptionResponse("Assignee", "WORD", 1, null));
        descs.add(new DescriptionResponse("Summary", "LINE", 0, null));
        descs.add(new DescriptionResponse("Description", "TEXT", 0, null));
        descs.add(new DescriptionResponse("Environment", "TEXT", 0, null));
        descs.add(new DescriptionResponse("Comments", "TEXT", 1, null));
        descs.add(new DescriptionResponse("Due Date", "DATE", 1, null));
        descs.add(new DescriptionResponse("Updated", "DATE", 2, null));
        descs.add(new DescriptionResponse("Issue Type", "SELECT", 0, issueTypesMap.keySet().toArray(new String[issueTypesMap.keySet().size()])));
        descs.add(new DescriptionResponse("Priority", "SELECT", 0, prioritiesMap.keySet().toArray(new String[prioritiesMap.keySet().size()])));
        descs.add(new DescriptionResponse("Resolution", "SELECT", 1, resolutionsMap.keySet().toArray(new String[resolutionsMap.keySet().size()])));
        descs.add(new DescriptionResponse("Status", "SELECT", 1, statusesMap.keySet().toArray(new String[statusesMap.keySet().size()])));
        descs.add(new DescriptionResponse("Affects Version/s", "LINE", 1, null));
        descs.add(new DescriptionResponse("Fix Version/s", "LINE", 1, null));
        descs.add(new DescriptionResponse("Component/s", "LINE", 1, null));
        descs.add(new DescriptionResponse("Fix", "FIX", 0, null));
        StatusResolutionFieldsResponseBuilder srfBuilder = new StatusResolutionFieldsResponseBuilder(this.configuration);
        srfBuilder.setStatusesMap(statusesMap);
        srfBuilder.setResolutionsMap(resolutionsMap);
        DescriptionResponse srf = srfBuilder.build();
        if (srf != null) {
            descs.add(srf);
        }
        CustomFieldsResponseBuilder cfBuilder = new CustomFieldsResponseBuilder(this.configuration);
        cfBuilder.setCustomFieldsMap(customFieldsMap);
        List<DescriptionResponse> cfs = cfBuilder.build();
        if (cfs != null) {
            descs.addAll(cfs);
        }
        return descs.toArray(new DescriptionResponse[descs.size()]);
    }

    @Override
    public StringResponse listProjects(Element request) throws RequestException {
        List<Object> projectKeys = new ArrayList();
        try {
            projectKeys = this.getAllProjectsCached();
            if (projectKeys.size() < 1) {
                throw new RestClientException("No projects found:  check jira permissions for jira user.", null);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while getting project list: " + e.toString(), "0"));
        }
        return new StringResponse(projectKeys.toArray(new String[projectKeys.size()]));
    }

    @Override
    public StringResponse getSegmentFilters(Element request) throws RequestException {
        String projId = request.getAttribute("PROJID");
        this.projectList = request.getAttribute("PROJECT_LIST");
        this.segmentFilter = request.getAttribute("SEGMENT_FILTER");
        SegmentFilterTranslator translator = new SegmentFilterTranslator();
        translator.setCustomFieldsMap(this.issueFieldsMapper.getCustomFieldsMap());
        translator.setIssueTypesMap(this.issueFieldsMapper.getIssueTypesMap(projId));
        translator.setPrioritiesMap(this.issueFieldsMapper.getPrioritiesMap());
        translator.setResolutionsMap(this.issueFieldsMapper.getResolutionsMap());
        translator.setStatusesMap(this.issueFieldsMapper.getStatusesMap());
        translator.setSegmentFilter(this.segmentFilter);
        this.segmentFilter = translator.translate();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "SEGMENT_FILTER: {0}", this.segmentFilter);
            logger.log(Level.FINER, "PROJECT_LIST: {0}", this.projectList);
        }
        return new StringResponse("OK");
    }

    @Override
    public StringResponse login(Element request) throws RequestException {
        this.jiraServerUrl = request.getAttribute("JIRA_URL");
        if (Utils.isEmpty(this.jiraServerUrl)) {
            throw new RequestException(new ErrorResponse("Missing JIRA_URL in login", "0"));
        }
        this.jiraUsername = request.getAttribute("JIRA_USER");
        if (Utils.isEmpty(this.jiraUsername)) {
            throw new RequestException(new ErrorResponse("Missing JIRA_USER in login", "0"));
        }
        this.jiraPassword = request.getAttribute("JIRA_PASSWORD");
        if (Utils.isEmpty(this.jiraPassword)) {
            throw new RequestException(new ErrorResponse("Missing JIRA_PASSWORD in login", "0"));
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occurred while logging into the JIRA server.", e);
            throw new RequestException(new ErrorResponse("Error occurred while logging into the JIRA server. Please make sure the JIRA server URL, username and password are correct. " + e.getMessage(), "0"));
        }
        return new StringResponse(this.getId());
    }

    @Override
    public StringResponse connect(Element request) throws RequestException {
        return new StringResponse("connected");
    }

    @Override
    public StringResponse ping(Element request) {
        return new StringResponse("PONG");
    }

    @Override
    public StringResponse getServerDate(Element request) throws RequestException {
        Date serverDate;
        SimpleDateFormat format;
        block5: {
            format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            serverDate = null;
            TimeCommand timer = new TimeCommand();
            String qMsg = ".";
            try {
                if (logger.isLoggable(Level.FINER)) {
                    qMsg = "getServerDate:  getServerInfo";
                    RequestHandler.logStart(qMsg, timer);
                }
                ServerInfo servInfo = this.restClientManager.getExtendedMetadataClient().getServerInfo().claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
                if (servInfo == null) break block5;
                DateTime serverTime = servInfo.getServerTime();
                if (serverTime != null) {
                    serverDate = serverTime.toDate();
                    break block5;
                }
                throw new RestClientException("server time not included in server info.  See KB.", null);
            }
            catch (RestClientException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                throw new RequestException(new ErrorResponse("Error occurred while getting the JIRA server date time: " + e.toString(), "0"));
            }
        }
        return new StringResponse(format.format(serverDate));
    }

    @Override
    public FieldResponse[] newDefect(Element request) throws RequestException {
        String projId = request.getAttribute("PROJID");
        if (Utils.isEmpty(projId)) {
            throw new RequestException(new ErrorResponse("Missing PROJID in newDefect", "0"));
        }
        if (projId.equalsIgnoreCase("*All*")) {
            throw new RequestException(new ErrorResponse("Invalid PROJID in newDefect", "0"));
        }
        Project project = null;
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        try {
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "newDefect: get project " + projId;
                RequestHandler.logStart(qMsg, timer);
            }
            project = this.restClientManager.getProjectClient().getProject(projId).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving project: " + projId + " :" + e.toString(), "0"));
        }
        if (project == null) {
            throw new RequestException(new ErrorResponse("Unknown project: " + projId, "0"));
        }
        Map<String, String[]> defectFields = this.getDefectFields(request);
        if (defectFields.containsKey("*Project*")) {
            defectFields.remove("*Project*");
        }
        DefaultDefectFieldsMapBuilder ddfmBuilder = new DefaultDefectFieldsMapBuilder(this.restClientManager);
        defectFields = ddfmBuilder.build();
        DefectFieldsResponseBuilder dfrBuilder = new DefectFieldsResponseBuilder();
        dfrBuilder.setFieldValueMap(defectFields);
        FieldResponse[] fieldResponses = dfrBuilder.build();
        ArrayList<FieldResponse> fields = new ArrayList<FieldResponse>();
        fields.addAll(Arrays.asList(fieldResponses));
        fields.add(new FieldResponse("*Project*", projId));
        return fields.toArray(new FieldResponse[fields.size()]);
    }

    @Override
    public StringResponse saveDefect(Element request) throws RequestException {
        String projId = this.getFieldValue(request, "PROJID");
        if (projId == null) {
            throw new RequestException(new ErrorResponse("Missing PROJID in saveDefect", "0"));
        }
        String defectName = this.getFieldValue(request, "DEFECTID");
        if (defectName == null) {
            throw new RequestException(new ErrorResponse("Missing DEFECT in saveDefect", "0"));
        }
        Issue issue = null;
        TimeCommand timer = new TimeCommand();
        String qMsg = ".";
        try {
            if (logger.isLoggable(Level.FINER)) {
                qMsg = "saveDefect: get issue " + defectName;
                RequestHandler.logStart(qMsg, timer);
            }
            issue = this.restClientManager.getExtendedIssueClient().getIssue(defectName).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while retrieving defect: " + defectName + " :" + e.toString(), "0"));
        }
        if (issue == null) {
            throw new RequestException(new ErrorResponse("Defect: " + defectName + " not found", "0"));
        }
        try {
            Map<String, String[]> defectFields = this.getDefectFields(request);
            if (defectFields != null) {
                defectFields.remove("*Project*");
                issue = this.updateIssue(issue, defectFields);
            }
        }
        catch (RestClientException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new RequestException(new ErrorResponse("Error occurred while saving defect: " + defectName + " :" + e.toString(), "0"));
        }
        return new StringResponse(issue.getKey());
    }

    private Issue updateIssue(Issue issue, Map<String, String[]> defectFields) throws RequestException {
        if (defectFields != null) {
            String[] fix;
            String[] resolution;
            Transition transition = null;
            FieldInput resolutionFieldInput = null;
            Comment comment = null;
            ArrayList<FieldInput> fieldInputs = new ArrayList<FieldInput>();
            TimeCommand timer = new TimeCommand();
            String qMsg = ".";
            String[] status = defectFields.remove("Status");
            if (!Utils.isEmpty(status) && (transition = this.issueFieldsMapper.getTransitionForTargetStatus(issue, status[0])) != null && !Utils.isEmpty(resolution = defectFields.remove("Resolution"))) {
                resolutionFieldInput = new FieldInput(Constants.ISSUE_FIELDS.get("Resolution"), (Object)ComplexIssueInputFieldValue.with("name", resolution[0]));
            }
            if (!Utils.isEmpty(fix = defectFields.remove("Fix"))) {
                comment = Comment.valueOf(fix[0]);
            }
            DefectFieldsTranslator dfTranslator = new DefectFieldsTranslator(defectFields, this.issueFieldsMapper, this.restClientManager);
            Map<String, String[]> issueFields = dfTranslator.translate();
            for (Map.Entry<String, String[]> entry : issueFields.entrySet()) {
                if (Utils.isEmpty(entry.getKey())) continue;
                if (this.isSelectInputField(entry.getKey())) {
                    if (Utils.isEmpty(entry.getValue())) continue;
                    if (entry.getKey().startsWith("customfield_")) {
                        fieldInputs.add(new FieldInput(entry.getKey(), (Object)ComplexIssueInputFieldValue.with("value", entry.getValue()[0])));
                        continue;
                    }
                    fieldInputs.add(new FieldInput(entry.getKey(), (Object)ComplexIssueInputFieldValue.with("id", entry.getValue()[0])));
                    continue;
                }
                fieldInputs.add(new FieldInput(entry.getKey(), (Object)entry.getValue()[0]));
            }
            IssueInput issueInput = IssueInput.createWithFields(fieldInputs.toArray(new FieldInput[fieldInputs.size()]));
            try {
                if (transition != null) {
                    TransitionInput transitionInput;
                    TransitionInput transitionInput2 = transitionInput = resolutionFieldInput != null ? new TransitionInput(transition.getId(), Arrays.asList(resolutionFieldInput), comment) : new TransitionInput(transition.getId(), Collections.emptyList(), comment);
                    if (logger.isLoggable(Level.FINER)) {
                        qMsg = "updateIssue: transition";
                        RequestHandler.logStart(qMsg, timer);
                    }
                    this.restClientManager.getExtendedIssueClient().transition(issue, transitionInput).claim();
                    if (logger.isLoggable(Level.FINER)) {
                        RequestHandler.logStop(qMsg, timer);
                    }
                } else if (comment != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        qMsg = "updateIssue: add comment";
                        RequestHandler.logStart(qMsg, timer);
                    }
                    this.restClientManager.getExtendedIssueClient().addComment(issue.getCommentsUri(), comment).claim();
                    if (logger.isLoggable(Level.FINER)) {
                        RequestHandler.logStop(qMsg, timer);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    qMsg = "updateIssue: update";
                    RequestHandler.logStart(qMsg, timer);
                }
                this.restClientManager.getExtendedIssueClient().updateIssue(issue.getKey(), issueInput).claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
                if (logger.isLoggable(Level.FINER)) {
                    qMsg = "updateIssue: re-retrieve issue";
                    RequestHandler.logStart(qMsg, timer);
                }
                issue = this.restClientManager.getExtendedIssueClient().getIssue(issue.getKey()).claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
            }
            catch (RestClientException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                throw new RequestException(new ErrorResponse("Error occurred while updating defect: " + e.toString(), "0"));
            }
        }
        return issue;
    }

    private Issue updateIssueStatus(Issue issue, Map<String, String[]> defectFields) throws RequestException {
        if (defectFields != null) {
            String[] fix;
            String[] resolution;
            Transition transition = null;
            FieldInput resolutionFieldInput = null;
            Comment comment = null;
            TimeCommand timer = new TimeCommand();
            String qMsg = ".";
            String[] status = defectFields.remove("Status");
            if (!Utils.isEmpty(status) && (transition = this.issueFieldsMapper.getTransitionForTargetStatus(issue, status[0])) != null && !Utils.isEmpty(resolution = defectFields.remove("Resolution"))) {
                resolutionFieldInput = new FieldInput(Constants.ISSUE_FIELDS.get("Resolution"), (Object)ComplexIssueInputFieldValue.with("name", resolution[0]));
            }
            if (!Utils.isEmpty(fix = defectFields.remove("Fix"))) {
                comment = Comment.valueOf(fix[0]);
            }
            try {
                if (transition != null) {
                    TransitionInput transitionInput;
                    TransitionInput transitionInput2 = transitionInput = resolutionFieldInput != null ? new TransitionInput(transition.getId(), Arrays.asList(resolutionFieldInput), comment) : new TransitionInput(transition.getId(), Collections.emptyList(), comment);
                    if (logger.isLoggable(Level.FINER)) {
                        qMsg = "updateIssueStatus: transition issue";
                        RequestHandler.logStart(qMsg, timer);
                    }
                    this.restClientManager.getExtendedIssueClient().transition(issue, transitionInput).claim();
                    if (logger.isLoggable(Level.FINER)) {
                        RequestHandler.logStop(qMsg, timer);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    qMsg = "updateIssueStatus: re-retrieve issue";
                    RequestHandler.logStart(qMsg, timer);
                }
                issue = this.restClientManager.getExtendedIssueClient().getIssue(issue.getKey()).claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
            }
            catch (RestClientException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                throw new RequestException(new ErrorResponse("Error occurred while updating defect status: " + e.toString(), "0"));
            }
        }
        return issue;
    }

    private boolean isSelectInputField(String fieldId) {
        if (fieldId != null) {
            if (fieldId.equals(Constants.ISSUE_FIELDS.get("Affects Version/s")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Component/s")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Fix Version/s")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Issue Type")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Priority")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Resolution")) || fieldId.equals(Constants.ISSUE_FIELDS.get("Status"))) {
                return true;
            }
            String type = this.issueFieldsMapper.getCustomFieldTypeById(fieldId);
            if (type != null && type.equalsIgnoreCase("SELECT")) {
                return true;
            }
        }
        return false;
    }

    private static void logStart(String qMsg, TimeCommand timer) {
        logger.log(logger.getLevel(), "START {0}", qMsg);
        timer.start();
    }

    private static void logStop(String qMsg, TimeCommand timer) {
        logger.log(logger.getLevel(), "DONE  {0} {1} ", new String[]{qMsg, timer.toString()});
    }

    private static void logStop(String qMsg, TimeCommand timer, String other) {
        if (other == null) {
            other = "";
        }
        logger.log(Level.INFO, "DONE  {0} {1} {2}", new String[]{qMsg, timer.toString(), other});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project getProjectCached(String projId) {
        Map<String, Project> map = PROJECT_CACHE;
        synchronized (map) {
            Project proj = PROJECT_CACHE.get(projId);
            if (proj == null) {
                TimeCommand timer = new TimeCommand();
                String qMsg = "getProjectCached:  getProject " + projId;
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStart(qMsg, timer);
                }
                proj = this.restClientManager.getProjectClient().getProject(projId).claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
                if (proj != null) {
                    PROJECT_CACHE.put(projId, proj);
                }
            }
            return proj;
        }
    }

    public boolean isUserExists(String userName) {
        User u = this.getUserCached(userName);
        return u != null;
    }

    private User getUserCached(String userName) {
        User user = USER_CACHE.get(userName);
        if (null == null) {
            TimeCommand timer = new TimeCommand();
            String qMsg = "getUserCached:  user " + userName;
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStart(qMsg, timer);
            }
            user = this.restClientManager.getUserClient().getUser(userName).claim();
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(qMsg, timer);
            }
            if (user != null) {
                USER_CACHE.put(userName, user);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllProjectsCached() {
        Integer n = LOCK_GET_PROJECT_COUNT;
        synchronized (n) {
            if (++GET_PROJECT_COUNT >= 30) {
                GET_PROJECT_COUNT = 0;
                ALL_PROJECT_KEYS.clear();
            }
            if (ALL_PROJECT_KEYS.size() < 1) {
                String qMsg = ".";
                TimeCommand timer = new TimeCommand();
                if (logger.isLoggable(Level.FINER)) {
                    qMsg = "getAllProjectsCached: get all projects";
                    RequestHandler.logStart(qMsg, timer);
                }
                Iterable<BasicProject> projects = this.restClientManager.getProjectClient().getAllProjects().claim();
                if (logger.isLoggable(Level.FINER)) {
                    RequestHandler.logStop(qMsg, timer);
                }
                if (projects != null) {
                    for (BasicProject project : projects) {
                        ALL_PROJECT_KEYS.add(project.getKey());
                    }
                }
                if (ALL_PROJECT_KEYS.size() < 1) {
                    throw new RestClientException("No projects found:  check jira permissions for jira user.", null);
                }
            }
        }
        return ALL_PROJECT_KEYS;
    }

    private int getCountAllProjects() {
        return this.getAllProjectsCached().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean hasProjectAccess(String projId) {
        Integer accessCode = PROJECT_ACCESS_CACHE.get(projId);
        if (accessCode != null) {
            return accessCode < 201;
        }
        try {
            if (logger.isLoggable(Level.FINER)) {
                this.projMessage = "hasProjectAccess for " + projId;
                RequestHandler.logStart(this.projMessage, this.projTimer);
            }
            if (this.restClientManager.isJiraCloudURL()) {
                logger.log(Level.INFO, "Running Enhanced JQL. ::hasProjectAccess");
                this.restClientManager.getSearchJqlClient().searchEnhancedJql("project = \"" + projId + "\" and updated < '2006/1/1'", 1, null, null).claim();
            } else {
                this.restClientManager.getSearchClient().searchJql("project = \"" + projId + "\" and updated < '2006/1/1'", 1, 0, null).claim();
            }
            accessCode = 0;
        }
        catch (RestClientException ex) {
            logger.log(Level.INFO, "RestClientException in hasProjectAccess(\"" + projId + "\"): " + ex.getMessage(), ex);
            accessCode = Utils.getErrorStatus(ex);
            logger.log(Level.WARNING, "User {0} denied access to project {1} (code {2}):  not replicating.  Check that your P4DTG user can access issues in this project", new String[]{this.jiraUsername, projId, accessCode.toString()});
        }
        finally {
            if (logger.isLoggable(Level.FINER)) {
                RequestHandler.logStop(this.projMessage, this.projTimer);
            }
        }
        PROJECT_ACCESS_CACHE.put(projId, accessCode);
        return accessCode < 201;
    }
}

