/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.perforce.p4dtg.plugin.jira.common.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JqlSearchBuilder {
    static Logger logger = Logger.getLogger(JqlSearchBuilder.class.getPackage().getName());
    private String projId = null;
    private String[] projects = null;
    private String date = null;
    private String modBy = null;
    private String modDate = null;
    private String userName = null;
    private String segmentFilter = null;
    private String orderBy = null;

    public String build() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        StringBuilder sb = new StringBuilder();
        if (this.projId != null || this.projects != null) {
            if (this.projId != null) {
                sb.append("project = \"").append(this.projId).append("\"");
            } else if (this.projects.length > 0) {
                boolean firstProject = true;
                sb.append("project in (");
                for (String project : this.projects) {
                    if (!firstProject) {
                        sb.append(",");
                    } else {
                        firstProject = false;
                    }
                    sb.append("\"").append(project).append("\"");
                }
                sb.append(")");
            }
        }
        if (this.modDate != null && this.date != null) {
            try {
                Date d = formatter.parse(this.date);
                this.addAnd(sb);
                sb.append(this.modDate.toLowerCase()).append(" > \"").append(formatter.format(d)).append("\"");
            }
            catch (ParseException e) {
                String msg = "JqlSearchBuilder:  Exception parsing date '" + this.date + "'";
                logger.log(Level.SEVERE, msg, e);
                throw new IllegalArgumentException();
            }
        }
        if (this.modBy == null || this.userName != null) {
            // empty if block
        }
        if (!Utils.isEmpty(this.segmentFilter)) {
            sb.append(" ").append(this.segmentFilter);
        }
        if (!Utils.isEmpty(this.orderBy)) {
            sb.append(" ").append(this.orderBy);
        }
        return sb.toString();
    }

    private void addAnd(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
    }

    public void setProjId(String projId) {
        this.projId = projId;
    }

    public void setProjects(String[] projects) {
        this.projects = projects;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setModBy(String modBy) {
        this.modBy = modBy;
    }

    public void setModDate(String modDate) {
        this.modDate = modDate;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setSegmentFilter(String segmentFilter) {
        this.segmentFilter = segmentFilter;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }
}

