/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptionsBuilder;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.EntityHelper;
import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.perforce.p4dtg.plugin.jira.common.Constants;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.rest.client.RestClientManager;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueFieldsMapper;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.joda.time.DateTime;

public class IssueInputFieldsBuilder {
    private static final Logger logger = Logger.getLogger(IssueInputFieldsBuilder.class.getPackage().getName());
    private RestClientManager restClientManager;
    private IssueFieldsMapper issueFieldsMapper;
    private Map<String, String[]> defectFields;
    private IssueInputBuilder issueInputBuilder;

    public IssueInputFieldsBuilder(String projectKey, Map<String, String[]> defectFields, IssueFieldsMapper issueFieldsMapper, RestClientManager restClientManager) {
        this.defectFields = defectFields;
        this.issueFieldsMapper = issueFieldsMapper;
        this.restClientManager = restClientManager;
        this.issueInputBuilder = this.createDefaultIssueInputBuilder(projectKey);
    }

    public IssueInput build() {
        if (this.defectFields != null) {
            String updated;
            String dueDate;
            String environment;
            String description;
            String assignee;
            String reporter;
            String summary;
            String[] comps;
            String components;
            String[] versions;
            String affectsVersions;
            String[] versions2;
            String fixVersions;
            Priority priority;
            IssueType issueType = this.restClientManager.getExtendedMetadataClient().getIssueType(Utils.getMapValue(this.defectFields, "Issue Type")).claim();
            if (issueType != null) {
                this.issueInputBuilder.setIssueType(issueType);
            }
            if ((priority = this.restClientManager.getExtendedMetadataClient().getPriority(Utils.getMapValue(this.defectFields, "Priority")).claim()) != null) {
                this.issueInputBuilder.setPriority(priority);
            }
            if ((fixVersions = Utils.getMapValue(this.defectFields, "Fix Version/s")) != null && (versions2 = fixVersions.split(", ")) != null) {
                this.issueInputBuilder.setFixVersionsNames(Arrays.asList(versions2));
            }
            if ((affectsVersions = Utils.getMapValue(this.defectFields, "Affects Version/s")) != null && (versions = affectsVersions.split(", ")) != null) {
                this.issueInputBuilder.setAffectedVersionsNames(Arrays.asList(versions));
            }
            if ((components = Utils.getMapValue(this.defectFields, "Component/s")) != null && (comps = components.split(", ")) != null) {
                this.issueInputBuilder.setComponentsNames(Arrays.asList(comps));
            }
            if ((summary = Utils.getMapValue(this.defectFields, "Summary")) != null) {
                this.issueInputBuilder.setSummary(summary);
            }
            if ((reporter = Utils.getMapValue(this.defectFields, "Reporter")) != null) {
                this.issueInputBuilder.setReporterName(reporter);
            }
            if ((assignee = Utils.getMapValue(this.defectFields, "Assignee")) != null) {
                this.issueInputBuilder.setAssigneeName(assignee);
            }
            if ((description = Utils.getMapValue(this.defectFields, "Description")) != null) {
                this.issueInputBuilder.setDescription(description);
            }
            if ((environment = Utils.getMapValue(this.defectFields, "Environment")) != null) {
                this.issueInputBuilder.setFieldValue(Constants.ISSUE_FIELDS.get("Environment"), environment);
            }
            if ((dueDate = Utils.getMapValue(this.defectFields, "Due Date")) != null) {
                try {
                    Calendar cal = Utils.parseCalendar(dueDate, "d/MMM/yy");
                    if (cal != null) {
                        this.issueInputBuilder.setDueDate(new DateTime(cal.getTimeInMillis()));
                    }
                }
                catch (ParseException pe) {
                    logger.warning(pe.getMessage());
                }
            }
            if ((updated = Utils.getMapValue(this.defectFields, "Updated")) != null) {
                try {
                    Calendar cal = Utils.parseCalendar(updated, "d/MMM/yy");
                    if (cal != null) {
                        this.issueInputBuilder.setFieldValue(Constants.ISSUE_FIELDS.get("Updated"), new DateTime(cal.getTimeInMillis()));
                    }
                }
                catch (ParseException pe) {
                    logger.warning(pe.getMessage());
                }
            }
            for (Map.Entry<String, String[]> entry : this.defectFields.entrySet()) {
                String type;
                String key = entry.getKey();
                String[] values = entry.getValue();
                if (key == null || values == null || values.length <= 0 || values[0] == null) continue;
                String value = values[0];
                Field field = this.issueFieldsMapper.getCustomFieldByName(key);
                if (field == null || field.getId() == null || field.getName() == null || (type = this.issueFieldsMapper.getCustomFieldTypeByName(field.getName())) == null) continue;
                String id = field.getId();
                if (type.equalsIgnoreCase("DATE")) {
                    try {
                        Date date = Utils.parseDate(value, "yyyy/MM/dd HH:mm:ss");
                        if (date != null) {
                            value = Utils.formatDate(date, "dd/MMM/yy h:mm a");
                        }
                    }
                    catch (ParseException pe) {
                        logger.warning(pe.getMessage());
                    }
                }
                if (type.equalsIgnoreCase("SELECT") && Constants.ISSUE_FIELDS.containsKey(value)) {
                    value = Constants.ISSUE_FIELDS.get(value);
                }
                if (Constants.ISSUE_FIELDS.containsKey(id)) {
                    id = Constants.ISSUE_FIELDS.get(id);
                }
                FieldInput fieldInput = null;
                fieldInput = type.equalsIgnoreCase("SELECT") ? new FieldInput(id, (Object)ComplexIssueInputFieldValue.with("value", value)) : new FieldInput(id, (Object)value);
                this.issueInputBuilder.setFieldInput(fieldInput);
            }
        }
        return this.issueInputBuilder.build();
    }

    private IssueInputBuilder createDefaultIssueInputBuilder(String projectKey) {
        CimIssueType issueType;
        Iterable<CimProject> metadataProjects = this.restClientManager.getExtendedIssueClient().getCreateIssueMetadata(new GetCreateIssueMetadataOptionsBuilder().withProjectKeys(projectKey).withExpandedIssueTypesFields().build()).claim();
        CimProject project = metadataProjects.iterator().next();
        try {
            issueType = EntityHelper.findEntityByName(project.getIssueTypes(), "Bug");
        }
        catch (NoSuchElementException e) {
            issueType = EntityHelper.findEntityByName(project.getIssueTypes(), "BUG");
        }
        Iterable<Object> allowedValuesForPriority = issueType.getField(IssueFieldId.PRIORITY_FIELD).getAllowedValues();
        BasicPriority priority = (BasicPriority)allowedValuesForPriority.iterator().next();
        IssueInputBuilder issueInputBuilder = new IssueInputBuilder(project, issueType, "New Issue").setAssigneeName(this.restClientManager.getUsername()).setPriority(priority);
        return issueInputBuilder;
    }
}

