/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.OptionalIterable;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.FieldType;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.config.CustomField;
import com.perforce.p4dtg.plugin.jira.rest.client.RestClientManager;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.RequestException;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.TransitionStatusMatcher;
import com.perforce.p4dtg.plugin.jira.tcp.internal.response.ErrorResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IssueFieldsMapper {
    private static final Logger logger = Logger.getLogger(IssueFieldsMapper.class.getPackage().getName());
    private RestClientManager restClientManager;
    private Configuration configuration;
    private TransitionStatusMatcher transitionStatusMatcher;

    public IssueFieldsMapper(RestClientManager restClientManger, Configuration configuration) {
        this.transitionStatusMatcher = new TransitionStatusMatcher(this.configuration);
        this.restClientManager = restClientManger;
        this.configuration = configuration;
        this.transitionStatusMatcher = new TransitionStatusMatcher(configuration);
    }

    public Map<String, String> getIssueTypesMap(String projId) {
        LinkedHashMap<String, String> map;
        block4: {
            block3: {
                OptionalIterable<IssueType> issueTypes;
                map = new LinkedHashMap<String, String>();
                if (projId == null || projId.equalsIgnoreCase("*All*")) break block3;
                Project project = this.restClientManager.getProjectClient().getProject(projId).claim();
                if (project == null || (issueTypes = project.getIssueTypes()) == null) break block4;
                for (IssueType type : issueTypes) {
                    if (type == null) continue;
                    map.put(type.getName(), type.getId().toString());
                }
                break block4;
            }
            Iterable<IssueType> issueTypes = this.restClientManager.getExtendedMetadataClient().getIssueTypes().claim();
            if (issueTypes != null) {
                for (IssueType type : issueTypes) {
                    if (type == null) continue;
                    map.put(type.getName(), type.getId().toString());
                }
            }
        }
        return map;
    }

    public Map<String, String> getPrioritiesMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterable<Priority> priorities = this.restClientManager.getExtendedMetadataClient().getPriorities().claim();
        if (priorities != null) {
            for (Priority priority : priorities) {
                if (priority == null) continue;
                map.put(priority.getName(), priority.getId().toString());
            }
        }
        return map;
    }

    public Map<String, String> getResolutionsMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterable<Resolution> resolutions = this.restClientManager.getExtendedMetadataClient().getResolutions().claim();
        if (resolutions != null) {
            for (Resolution resolution : resolutions) {
                if (resolution == null) continue;
                map.put(resolution.getName(), Utils.getIdFromUri(resolution.getSelf()));
            }
        }
        return map;
    }

    public Map<String, String> getStatusesMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterable<Status> statuses = this.restClientManager.getExtendedMetadataClient().getStatuses().claim();
        if (statuses != null) {
            for (Status status : statuses) {
                if (status == null) continue;
                map.put(status.getName(), Utils.getIdFromUri(status.getSelf()));
            }
        }
        return map;
    }

    public Map<String, String> getCustomFieldsMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterable<Field> fields = this.restClientManager.getExtendedMetadataClient().getFields().claim();
        if (fields != null) {
            for (Field field : fields) {
                if (field == null || field.getFieldType() != FieldType.CUSTOM) continue;
                map.put(field.getId(), field.getName());
            }
        }
        return map;
    }

    public Map<String, String> getComponentsMap(String projectKey) {
        Iterable<BasicComponent> components;
        Project project;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (projectKey != null && (project = this.restClientManager.getProjectClient().getProject(projectKey).claim()) != null && (components = project.getComponents()) != null) {
            for (BasicComponent component : components) {
                if (component == null) continue;
                map.put(component.getName(), component.getId().toString());
            }
        }
        return map;
    }

    public Map<String, String> getVersionsMap(String projectKey) {
        Iterable<Version> versions;
        Project project;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (projectKey != null && (project = this.restClientManager.getProjectClient().getProject(projectKey).claim()) != null && (versions = project.getVersions()) != null) {
            for (Version version : versions) {
                if (version == null) continue;
                map.put(version.getName(), version.getId().toString());
            }
        }
        return map;
    }

    public Map<String, String> getActionsMap(String issueKey) {
        Iterable<Transition> transitions;
        Issue issue;
        HashMap<String, String> map = new HashMap<String, String>();
        if (issueKey != null && (issue = this.restClientManager.getExtendedIssueClient().getIssue(issueKey).claim()) != null && (transitions = this.restClientManager.getExtendedIssueClient().getTransitions(issue).claim()) != null) {
            for (Transition transitioin : transitions) {
                if (transitioin == null) continue;
                map.put(transitioin.getName(), String.valueOf(transitioin.getId()));
            }
        }
        return map;
    }

    public Map<String, String[]> getStatusResolutionMap(Map<String, String[]> defectFields) {
        HashMap<String, String[]> statusResolutionFields = new HashMap<String, String[]>();
        if (defectFields != null && defectFields.containsKey("Status")) {
            statusResolutionFields.put("Status", defectFields.get("Status"));
            if (defectFields.containsKey("Resolution")) {
                statusResolutionFields.put("Resolution", defectFields.get("Resolution"));
            }
        }
        return statusResolutionFields;
    }

    public boolean isDifferentStatusResolution(Issue issue, Map<String, String[]> statusResolutionFields) {
        if (issue != null && statusResolutionFields != null) {
            StringBuilder current = null;
            StringBuilder update = null;
            String status = Utils.getMapValue(statusResolutionFields, "Status");
            String resolution = Utils.getMapValue(statusResolutionFields, "Resolution");
            if (!Utils.isEmpty(status)) {
                update = new StringBuilder();
                update.append(status);
                if (!Utils.isEmpty(resolution)) {
                    update.append("/").append(resolution);
                }
                if (issue.getStatus() != null) {
                    current = new StringBuilder();
                    current.append(issue.getStatus().getName());
                    if (issue.getResolution() != null) {
                        current.append("/").append(issue.getResolution().getName());
                    }
                }
            }
            if (current != null && update != null && !current.toString().equalsIgnoreCase(update.toString())) {
                return true;
            }
        }
        return false;
    }

    public Transition getTransitionForTargetStatus(Issue issue, String targetStatus) throws RequestException {
        Transition transition = null;
        if (targetStatus != null) {
            try {
                Status currentStatus = issue.getStatus();
                Map<String, String> actions = this.transitionStatusMatcher.lookupActions(currentStatus.getName(), targetStatus);
                if (actions == null || actions.isEmpty()) {
                    String message = "Error occurred while saving defect: no transition defined for current status to target status:  issue key (" + issue.getKey() + "), current status (" + currentStatus.getName() + "), target status (" + targetStatus + ")";
                    throw new RequestException(new ErrorResponse(message, "0"));
                }
                Iterable<Transition> transitions = this.restClientManager.getExtendedIssueClient().getTransitions(issue).claim();
                if (transitions == null) {
                    String message = "Error occurred while saving defect: no transitions available for current status:  issue key (" + issue.getKey() + "), current status (" + currentStatus.getName() + "), target status (" + targetStatus + ")";
                    throw new RequestException(new ErrorResponse(message, "0"));
                }
                for (Transition t2 : transitions) {
                    if (!actions.containsKey(t2.getName())) continue;
                    transition = t2;
                    break;
                }
                if (transition == null) {
                    String message = "Error occurred while saving defect: no matching transition found for current status:  issue key (" + issue.getKey() + "), current status (" + currentStatus.getName() + "), target status (" + targetStatus + ")";
                    throw new RequestException(new ErrorResponse(message, "0"));
                }
            }
            catch (RestClientException e) {
                throw new RequestException(new ErrorResponse("Error occurred while saving defect: " + issue.getKey() + " :" + e.toString(), "0"));
            }
        }
        return transition;
    }

    public Field getCustomFieldByName(String name) {
        Iterable<Field> fields;
        Field customField = null;
        if (name != null && (fields = this.restClientManager.getExtendedMetadataClient().getFields().claim()) != null) {
            for (Field field : fields) {
                if (field == null || field.getFieldType() != FieldType.CUSTOM || !field.getName().equals(name)) continue;
                return field;
            }
        }
        return customField;
    }

    public String getCustomFieldTypeById(String id) {
        String name;
        Map<String, String> cfsm;
        String type = null;
        if (id != null && this.configuration != null && this.configuration.getCustomFields() != null && (cfsm = this.getCustomFieldsMap()) != null && (name = cfsm.get(id)) != null) {
            for (CustomField cf : this.configuration.getCustomFields()) {
                if (cf == null || cf.getName() == null || cf.getType() == null || !cf.getName().trim().equalsIgnoreCase(name)) continue;
                if (cf.getType().trim().equalsIgnoreCase("WORD")) {
                    type = "WORD";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("LINE")) {
                    type = "LINE";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("TEXT")) {
                    type = "TEXT";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("DATE")) {
                    type = "DATE";
                    continue;
                }
                if (!cf.getType().trim().equalsIgnoreCase("SELECT")) continue;
                type = "SELECT";
            }
        }
        return type;
    }

    public String getCustomFieldTypeByName(String name) {
        String type = null;
        if (name != null && this.configuration != null && this.configuration.getCustomFields() != null) {
            for (CustomField cf : this.configuration.getCustomFields()) {
                if (cf == null || cf.getName() == null || cf.getType() == null || !cf.getName().trim().equalsIgnoreCase(name)) continue;
                if (cf.getType().trim().equalsIgnoreCase("WORD")) {
                    type = "WORD";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("LINE")) {
                    type = "LINE";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("TEXT")) {
                    type = "TEXT";
                    continue;
                }
                if (cf.getType().trim().equalsIgnoreCase("DATE")) {
                    type = "DATE";
                    continue;
                }
                if (!cf.getType().trim().equalsIgnoreCase("SELECT")) continue;
                type = "SELECT";
            }
        }
        return type;
    }

    public int getIssueKeyNumber(String issueKey) {
        String[] parts;
        int issueKeyNumber = -1;
        if (issueKey != null && (parts = issueKey.split("-")) != null && parts.length > 1 && parts[1] != null) {
            try {
                issueKeyNumber = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Exception parsing issue key number.", e);
            }
        }
        return issueKeyNumber;
    }

    public int nextIssueKeyNumberLow(String projectKey, int issueKeyNumber, int upperLimit) {
        int issueKeyNumberLow = -1;
        if (!Utils.isEmpty(projectKey) && issueKeyNumber > 0) {
            for (int nextIssueKeyNumber = issueKeyNumber; nextIssueKeyNumber <= upperLimit; ++nextIssueKeyNumber) {
                String issueKey = projectKey + "-" + nextIssueKeyNumber;
                Issue issue = this.restClientManager.getExtendedIssueClient().getIssue(issueKey).claim();
                if (issue == null) continue;
                issueKeyNumberLow = this.getIssueKeyNumber(issue.getKey());
                break;
            }
        }
        return issueKeyNumberLow;
    }

    public int nextIssueKeyNumberHigh(String projectKey, int issueKeyNumber, int lowerLimit) {
        int issueKeyNumberHigh = -1;
        if (!Utils.isEmpty(projectKey) && issueKeyNumber > 0) {
            for (int nextIssueKeyNumber = issueKeyNumber; nextIssueKeyNumber >= lowerLimit; --nextIssueKeyNumber) {
                String issueKey = projectKey + "-" + nextIssueKeyNumber;
                Issue issue = this.restClientManager.getExtendedIssueClient().getIssue(issueKey).claim();
                if (issue == null) continue;
                issueKeyNumberHigh = this.getIssueKeyNumber(issue.getKey());
                break;
            }
        }
        return issueKeyNumberHigh;
    }
}

