/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.perforce.p4dtg.plugin.jira.common.Constants;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.rest.client.RestClientManager;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueFieldsMapper;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DefectFieldsTranslator {
    private static final Logger logger = Logger.getLogger(DefectFieldsTranslator.class.getPackage().getName());
    private RestClientManager restClientManager;
    private IssueFieldsMapper issueFieldsMapper;
    private Map<String, String[]> defectFields;

    public DefectFieldsTranslator(Map<String, String[]> defectFields, IssueFieldsMapper fieldsMapper, RestClientManager restClientManager) {
        this.defectFields = defectFields;
        this.issueFieldsMapper = fieldsMapper;
        this.restClientManager = restClientManager;
    }

    public Map<String, String[]> translate() {
        HashMap<String, String[]> issueFields = new HashMap<String, String[]>();
        if (this.defectFields != null && this.issueFieldsMapper != null && this.restClientManager != null) {
            String[] comps;
            String components;
            String[] versions;
            String affectsVersions;
            String[] versions2;
            String fixVersions;
            Resolution resolution;
            Status status;
            Priority priority;
            IssueType issueType;
            String description;
            String assignee;
            String reporter;
            String summary;
            String fix;
            String updated;
            String dueDate = Utils.getMapValue(this.defectFields, "Due Date");
            if (dueDate != null) {
                try {
                    Date date = Utils.parseDate(dueDate, "yyyy/MM/dd HH:mm:ss");
                    if (date != null) {
                        issueFields.put(Constants.ISSUE_FIELDS.get("Due Date"), new String[]{Utils.formatDate(date, "d/MMM/yy")});
                    }
                }
                catch (ParseException pe) {
                    logger.warning(pe.getMessage());
                }
            }
            if ((updated = Utils.getMapValue(this.defectFields, "Updated")) != null) {
                try {
                    Date date = Utils.parseDate(updated, "yyyy/MM/dd HH:mm:ss");
                    if (date != null) {
                        issueFields.put(Constants.ISSUE_FIELDS.get("Updated"), new String[]{Utils.formatDate(date, "d/MMM/yy")});
                    }
                }
                catch (ParseException pe) {
                    logger.warning(pe.getMessage());
                }
            }
            if ((fix = Utils.getMapValue(this.defectFields, "Fix")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Comments"), new String[]{fix});
            }
            if ((summary = Utils.getMapValue(this.defectFields, "Summary")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Summary"), new String[]{summary});
            }
            if ((reporter = Utils.getMapValue(this.defectFields, "Reporter")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Reporter"), new String[]{reporter});
            }
            if ((assignee = Utils.getMapValue(this.defectFields, "Assignee")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Assignee"), new String[]{assignee});
            }
            if ((description = Utils.getMapValue(this.defectFields, "Description")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Description"), new String[]{description});
            }
            if ((issueType = this.restClientManager.getExtendedMetadataClient().getIssueType(Utils.getMapValue(this.defectFields, "Issue Type")).claim()) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Issue Type"), new String[]{issueType.getId().toString()});
            }
            if ((priority = this.restClientManager.getExtendedMetadataClient().getPriority(Utils.getMapValue(this.defectFields, "Priority")).claim()) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Priority"), new String[]{priority.getId().toString()});
            }
            if ((status = this.restClientManager.getExtendedMetadataClient().getStatus(Utils.getMapValue(this.defectFields, "Status")).claim()) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Status"), new String[]{Utils.getIdFromUri(status.getSelf())});
            }
            if ((resolution = this.restClientManager.getExtendedMetadataClient().getResolution(Utils.getMapValue(this.defectFields, "Resolution")).claim()) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Resolution"), new String[]{Utils.getIdFromUri(resolution.getSelf())});
            }
            if ((fixVersions = Utils.getMapValue(this.defectFields, "Fix Version/s")) != null && (versions2 = fixVersions.split(", ")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Fix Version/s"), versions2);
            }
            if ((affectsVersions = Utils.getMapValue(this.defectFields, "Affects Version/s")) != null && (versions = affectsVersions.split(", ")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Affects Version/s"), versions);
            }
            if ((components = Utils.getMapValue(this.defectFields, "Component/s")) != null && (comps = components.split(", ")) != null) {
                issueFields.put(Constants.ISSUE_FIELDS.get("Component/s"), comps);
            }
            for (Map.Entry<String, String[]> entry : this.defectFields.entrySet()) {
                String key = entry.getKey();
                String[] values = entry.getValue();
                if (key == null || values == null || values.length <= 0 || values[0] == null) continue;
                String value = values[0];
                Field field = this.issueFieldsMapper.getCustomFieldByName(key);
                if (field == null) continue;
                key = field.getId();
                String type = this.issueFieldsMapper.getCustomFieldTypeByName(field.getName());
                if (type != null) {
                    if (type.equalsIgnoreCase("DATE")) {
                        try {
                            Date date = Utils.parseDate(value, "yyyy/MM/dd HH:mm:ss");
                            if (date != null) {
                                value = Utils.formatDate(date, "dd/MMM/yy h:mm a");
                            }
                        }
                        catch (ParseException pe) {
                            logger.warning(pe.getMessage());
                        }
                    }
                    if (type.equalsIgnoreCase("SELECT") && Constants.ISSUE_FIELDS.containsKey(value)) {
                        value = Constants.ISSUE_FIELDS.get(value);
                    }
                }
                if (Constants.ISSUE_FIELDS.containsKey(key)) {
                    key = Constants.ISSUE_FIELDS.get(key);
                }
                issueFields.put(key, new String[]{value});
            }
        }
        return issueFields;
    }
}

