/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.DefectCustomFieldsMapBuilder;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueFieldsMapper;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.UserNameHelper;
import java.util.HashMap;
import java.util.Map;

public class DefectFieldsMapBuilder {
    private Configuration configuration;
    private Issue issue;
    private IssueFieldsMapper issueFieldsMapper;

    public DefectFieldsMapBuilder(Issue issue, IssueFieldsMapper issueFieldsMapper, Configuration configuration) {
        this.issue = issue;
        this.issueFieldsMapper = issueFieldsMapper;
        this.configuration = configuration;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String[]> build() {
        HashMap<String, String[]> fieldValueMap = new HashMap<String, String[]>();
        if (this.issue != null && this.configuration != null && this.issueFieldsMapper != null) {
            DefectCustomFieldsMapBuilder defectCustomFieldsMapBuilder;
            Map<String, String[]> map;
            Iterable<BasicComponent> components;
            Iterable<Version> fixVersions;
            Iterable<Version> affectsVersions;
            Iterable<Comment> comments;
            IssueField envField;
            if (this.issue.getKey() != null) {
                fieldValueMap.put("Issue Key", new String[]{this.issue.getKey()});
            }
            if (this.issue.getReporter() != null) {
                fieldValueMap.put("Reporter", new String[]{UserNameHelper.getUserValue(this.issue.getReporter())});
            }
            if (this.issue.getAssignee() != null) {
                fieldValueMap.put("Assignee", new String[]{UserNameHelper.getUserValue(this.issue.getAssignee())});
            }
            if (this.issue.getSummary() != null) {
                fieldValueMap.put("Summary", new String[]{this.issue.getSummary()});
            }
            if (this.issue.getDescription() != null) {
                fieldValueMap.put("Description", new String[]{this.issue.getDescription()});
            }
            if ((envField = this.issue.getFieldByName("Environment")) != null && envField.getValue() != null) {
                fieldValueMap.put("Environment", new String[]{envField.getValue().toString()});
            }
            if ((comments = this.issue.getComments()) != null) {
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (Comment comment : comments) {
                    if (count > 0) {
                        sb.append("\n------\n");
                    }
                    sb.append(comment.getBody());
                    ++count;
                }
                fieldValueMap.put("Comments", new String[]{sb.toString()});
            }
            if ((affectsVersions = this.issue.getAffectedVersions()) != null) {
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (Version version : affectsVersions) {
                    if (count > 0) {
                        sb.append(", ");
                    }
                    sb.append(version.getName());
                    ++count;
                }
                fieldValueMap.put("Affects Version/s", new String[]{sb.toString()});
            }
            if ((fixVersions = this.issue.getFixVersions()) != null) {
                StringBuilder sb = new StringBuilder();
                boolean bl = false;
                for (Version version : fixVersions) {
                    void var7_14;
                    if (var7_14 > 0) {
                        sb.append(", ");
                    }
                    sb.append(version.getName());
                    ++var7_14;
                }
                fieldValueMap.put("Fix Version/s", new String[]{sb.toString()});
            }
            if ((components = this.issue.getComponents()) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (BasicComponent component : components) {
                    void var8_21;
                    if (var8_21 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(component.getName());
                    ++var8_21;
                }
                fieldValueMap.put("Component/s", new String[]{stringBuilder.toString()});
            }
            if (this.issue.getDueDate() != null) {
                fieldValueMap.put("Due Date", new String[]{Utils.formatDate(this.issue.getDueDate().toDate(), "yyyy/MM/dd HH:mm:ss")});
            }
            if (this.issue.getUpdateDate() != null) {
                fieldValueMap.put("Updated", new String[]{Utils.formatDate(this.issue.getUpdateDate().toDate(), "yyyy/MM/dd HH:mm:ss")});
            }
            if (this.issue.getIssueType() != null) {
                fieldValueMap.put("Issue Type", new String[]{this.issue.getIssueType().getName()});
            }
            if (this.issue.getPriority() != null) {
                fieldValueMap.put("Priority", new String[]{this.issue.getPriority().getName()});
            }
            if (this.issue.getStatus() != null) {
                fieldValueMap.put("Status", new String[]{this.issue.getStatus().getName()});
            }
            if (this.issue.getResolution() != null) {
                fieldValueMap.put("Resolution", new String[]{this.issue.getResolution().getName()});
            }
            if ((map = (defectCustomFieldsMapBuilder = new DefectCustomFieldsMapBuilder(this.issue, this.issueFieldsMapper, this.configuration)).build()) != null) {
                fieldValueMap.putAll(map);
            }
        }
        return fieldValueMap;
    }
}

