/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.tcp.internal.request;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.perforce.p4dtg.plugin.jira.common.Utils;
import com.perforce.p4dtg.plugin.jira.config.Configuration;
import com.perforce.p4dtg.plugin.jira.config.CustomField;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.IssueFieldsMapper;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DefectCustomFieldsMapBuilder {
    static Logger logger = Logger.getLogger(DefectCustomFieldsMapBuilder.class.getPackage().getName());
    private Configuration configuration;
    private Issue issue;
    private IssueFieldsMapper issueFieldsMapper;

    public DefectCustomFieldsMapBuilder(Issue issue, IssueFieldsMapper issueFieldsMapper, Configuration configuration) {
        this.issue = issue;
        this.issueFieldsMapper = issueFieldsMapper;
        this.configuration = configuration;
    }

    public Map<String, String[]> build() {
        HashMap<String, String[]> fieldValueMap = new HashMap<String, String[]>();
        if (this.issue != null && this.configuration != null && this.issueFieldsMapper != null) {
            Iterable<IssueField> fields;
            Map<String, String[]> customFieldSelectValues = this.buildEmptySelectOptions();
            if (customFieldSelectValues != null) {
                fieldValueMap.putAll(customFieldSelectValues);
            }
            if ((fields = this.issue.getFields()) != null) {
                for (IssueField field : fields) {
                    if (field == null || field.getId() == null || field.getName() == null || field.getValue() == null) continue;
                    String type = this.issueFieldsMapper.getCustomFieldTypeByName(field.getName());
                    String name = field.getName();
                    if (type == null) continue;
                    String value = "";
                    if (type.equalsIgnoreCase("SELECT")) {
                        if (field.getValue() instanceof JSONObject) {
                            try {
                                value = ((JSONObject)field.getValue()).getString("value");
                            }
                            catch (JSONException e) {
                                logger.warning("Error getting the field " + field.getName() + " value: " + e.getLocalizedMessage());
                            }
                        }
                    } else if (field.getValue() instanceof String) {
                        value = (String)field.getValue();
                    } else if (field.getValue() instanceof JSONArray) {
                        JSONArray values = (JSONArray)field.getValue();
                        try {
                            value = values.join(", ");
                        }
                        catch (JSONException ex) {
                            logger.warning("Error getting the field " + field.getName() + "  value: " + ex.getLocalizedMessage());
                        }
                    } else if (field.getValue() instanceof Integer) {
                        value = ((Integer)field.getValue()).toString();
                    } else if (field.getValue() instanceof Double) {
                        value = ((Double)field.getValue()).toString();
                    }
                    if (type.equalsIgnoreCase("DATE")) {
                        Date date = null;
                        try {
                            date = Utils.parseDate(value, "dd/MMM/yy h:mm a");
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (date == null) {
                            try {
                                date = Utils.parseDate(value, "dd/MMM/yy");
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (date != null) {
                            value = Utils.formatDate(date, "yyyy/MM/dd HH:mm:ss");
                        } else {
                            logger.warning("Error parsing the date: " + value);
                        }
                    }
                    fieldValueMap.put(name, new String[]{value});
                }
            }
        }
        return fieldValueMap;
    }

    private Map<String, String[]> buildEmptySelectOptions() {
        LinkedHashMap<String, String[]> customFieldValues = new LinkedHashMap<String, String[]>();
        if (this.configuration != null && this.configuration.getCustomFields() != null) {
            for (CustomField cf : this.configuration.getCustomFields()) {
                if (cf == null || cf.getName() == null || cf.getType() == null || !cf.getType().trim().equalsIgnoreCase("SELECT")) continue;
                customFieldValues.put(cf.getName(), new String[]{"<Empty>"});
            }
        }
        return customFieldValues;
    }
}

