/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.internal.search;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.perforce.p4dtg.plugin.jira.rest.client.RestClientManager;
import com.perforce.p4dtg.plugin.jira.rest.search.SearchService;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JqlSearcher
implements SearchService {
    private RestClientManager clientManager = null;
    private static final Logger logger = Logger.getLogger(JqlSearcher.class.getPackage().getName());

    public JqlSearcher(RestClientManager clientManager) {
        this.clientManager = clientManager;
    }

    @Override
    public Iterable<Issue> searchIssues(String jql) {
        return this.searchIssues(jql, null);
    }

    @Override
    public Iterable<Issue> searchIssues(String jql, Integer maxResults) {
        return this.searchIssues(jql, maxResults, null, null);
    }

    @Override
    public Iterable<Issue> searchIssues(String jql, Integer maxResults, Integer startAt) {
        SearchResult searchResult;
        if (this.clientManager.isJiraCloudURL()) {
            logger.log(Level.INFO, "Running Enhanced JQL. JqlSearcher::searchIssues");
            searchResult = this.clientManager.getSearchJqlClient().searchEnhancedJql(jql, maxResults, null, null).claim();
        } else {
            searchResult = this.clientManager.getSearchClient().searchJql(jql, maxResults, startAt, null).claim();
        }
        return searchResult == null ? Collections.emptyList() : searchResult.getIssues();
    }

    @Override
    public Iterable<Issue> searchIssues(String jql, Integer maxResults, Integer startAt, Set<String> fields) {
        SearchResult searchResult;
        if (this.clientManager.isJiraCloudURL()) {
            logger.log(Level.INFO, "Running Enhanced JQL. JqlSearcher::searchIssues with fields");
            searchResult = this.clientManager.getSearchJqlClient().searchEnhancedJql(jql, maxResults, null, fields).claim();
        } else {
            searchResult = this.clientManager.getSearchClient().searchJql(jql, maxResults, startAt, fields).claim();
        }
        return searchResult == null ? Collections.emptyList() : searchResult.getIssues();
    }
}

