/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.internal.client;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchResult;
import java.util.Collections;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class P4DTGSearchResultJsonParser
implements JsonObjectParser<P4DTGSearchResult> {
    @Override
    public P4DTGSearchResult parse(JSONObject json) throws JSONException {
        Iterable<Object> issues;
        boolean isLastPage = json.optBoolean("isLast", false);
        String nextPageToken = json.optString("nextPageToken", null);
        JSONArray issuesJsonArray = json.getJSONArray("issues");
        if (issuesJsonArray.length() > 0) {
            IssueJsonParser issueParser = new IssueJsonParser(json.getJSONObject("names"), json.getJSONObject("schema"));
            GenericJsonArrayParser<Issue> issuesParser = GenericJsonArrayParser.create(issueParser);
            issues = issuesParser.parse(issuesJsonArray);
        } else {
            issues = Collections.emptyList();
        }
        int total = issuesJsonArray.length();
        P4DTGSearchResult searchResult = new P4DTGSearchResult(0, 0, total, (Iterable<Issue>)issues);
        searchResult.setLastPage(isLastPage);
        searchResult.setNextPageToken(nextPageToken);
        return searchResult;
    }
}

