/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.internal.client;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Filter;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.FilterJsonParser;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.google.common.base.Joiner;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchRestClient;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchResult;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchResultJsonParser;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class P4DTGAsynchronousSearchRestClient
extends AbstractAsynchronousRestClient
implements P4DTGSearchRestClient {
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final String JQL_ATTRIBUTE = "jql";
    private static final String FILTER_FAVOURITE_PATH = "filter/favourite";
    private static final String FILTER_PATH_FORMAT = "filter/%s";
    private static final String SEARCH_URI_PREFIX = "search/jql";
    private static final String EXPAND_ATTRIBUTE = "expand";
    private static final String FIELDS_ATTRIBUTE = "fields";
    public static final String NEXT_PAGE_TOKEN = "nextPageToken";
    private final P4DTGSearchResultJsonParser searchResultJsonParser = new P4DTGSearchResultJsonParser();
    private final FilterJsonParser filterJsonParser = new FilterJsonParser();
    private final GenericJsonArrayParser<Filter> filtersParser = GenericJsonArrayParser.create(new FilterJsonParser());
    private final URI searchUri;
    private final URI favouriteUri;
    private final URI baseUri;

    public P4DTGAsynchronousSearchRestClient(URI serverUri, HttpClient asyncHttpClient) {
        super(asyncHttpClient);
        URI baseUri;
        this.baseUri = baseUri = UriBuilder.fromUri(serverUri).path("/rest/api/latest").build(new Object[0]);
        this.searchUri = UriBuilder.fromUri(baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
        this.favouriteUri = UriBuilder.fromUri(baseUri).path(FILTER_FAVOURITE_PATH).build(new Object[0]);
    }

    @Override
    public Promise<P4DTGSearchResult> searchEnhancedJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, @Nullable Set<String> fields) {
        String expandoValues = IssueRestClient.Expandos.SCHEMA.name().toLowerCase() + "," + IssueRestClient.Expandos.NAMES.name().toLowerCase();
        String notNullJql = StringUtils.defaultString(jql);
        return notNullJql.length() > 500 ? this.searchJqlImplPost(maxResults, nextPageToken, expandoValues, notNullJql, fields) : this.searchJqlImplGet(maxResults, nextPageToken, expandoValues, notNullJql, fields);
    }

    private Promise<P4DTGSearchResult> searchJqlImplGet(@Nullable Integer maxResults, String nextPageToken, String expandoValues, String jql, @Nullable Set<String> fields) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.searchUri).queryParam(JQL_ATTRIBUTE, jql).queryParam(EXPAND_ATTRIBUTE, expandoValues);
        if (fields != null) {
            uriBuilder.queryParam(FIELDS_ATTRIBUTE, Joiner.on(",").join(fields));
        }
        this.addOptionalQueryParam(uriBuilder, NEXT_PAGE_TOKEN, nextPageToken);
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.searchResultJsonParser);
    }

    private void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object ... values) {
        if (values != null && values.length > 0 && values[0] != null) {
            uriBuilder.queryParam(key, values);
        }
    }

    private Promise<P4DTGSearchResult> searchJqlImplPost(@Nullable Integer maxResults, @Nullable String nextPageToken, String expandoValues, String jql, @Nullable Set<String> fields) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put(JQL_ATTRIBUTE, jql).put(EXPAND_ATTRIBUTE, expandoValues).putOpt(MAX_RESULTS_ATTRIBUTE, maxResults).putOpt(NEXT_PAGE_TOKEN, nextPageToken);
            if (fields != null) {
                postEntity.put(FIELDS_ATTRIBUTE, fields);
            }
        }
        catch (JSONException var8) {
            JSONException e = var8;
            throw new RestClientException(e);
        }
        return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
    }

    @Override
    public Promise<Iterable<Filter>> getFavouriteFilters() {
        return this.getAndParse(this.favouriteUri, this.filtersParser);
    }

    @Override
    public Promise<Filter> getFilter(URI filterUri) {
        return this.getAndParse(filterUri, this.filterJsonParser);
    }

    @Override
    public Promise<Filter> getFilter(long id) {
        return this.getFilter(UriBuilder.fromUri(this.baseUri).path(String.format(FILTER_PATH_FORMAT, id)).build(new Object[0]));
    }

    @Override
    @Deprecated
    public Promise<SearchResult> searchJql(@Nullable String jql) {
        return this.searchJql(jql, null, 0, null);
    }

    @Override
    @Deprecated
    public Promise<SearchResult> searchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable Integer startAt, @Nullable Set<String> fields) {
        return this.searchEnhancedJql(jql, maxResults, null, fields).map(result -> result);
    }
}

