/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.internal.client;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.internal.async.AsynchronousMetadataRestClient;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.PriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import com.perforce.p4dtg.plugin.jira.rest.client.ExtendedMetadataRestClient;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousExtendedMetadataRestClient
extends AsynchronousMetadataRestClient
implements ExtendedMetadataRestClient {
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final GenericJsonArrayParser<Status> statusesJsonParser = GenericJsonArrayParser.create(this.statusJsonParser);
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final GenericJsonArrayParser<IssueType> issueTypesJsonParser = GenericJsonArrayParser.create(this.issueTypeJsonParser);
    private final PriorityJsonParser priorityJsonParser = new PriorityJsonParser();
    private final GenericJsonArrayParser<Priority> prioritiesJsonParser = GenericJsonArrayParser.create(this.priorityJsonParser);
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();
    private final GenericJsonArrayParser<Resolution> resolutionsJsonParser = GenericJsonArrayParser.create(this.resolutionJsonParser);
    private final URI baseUri;

    public AsynchronousExtendedMetadataRestClient(URI baseUri, HttpClient httpClient) {
        super(baseUri, httpClient);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<Iterable<Status>> getStatuses() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("status").build(new Object[0]);
        return this.getAndParse(uri, this.statusesJsonParser);
    }

    @Override
    public Promise<IssueType> getIssueType(String type) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("issuetype").build(new Object[0]);
        Iterable issueTypes = (Iterable)this.getAndParse(uri, this.issueTypesJsonParser).claim();
        if (issueTypes != null) {
            for (IssueType issueType : issueTypes) {
                if (!issueType.getName().equalsIgnoreCase(type)) continue;
                return Promises.promise(issueType);
            }
        }
        return Promises.promise(null);
    }

    @Override
    public Promise<Status> getStatus(String status) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("status").build(new Object[0]);
        Iterable issueStatuses = (Iterable)this.getAndParse(uri, this.statusesJsonParser).claim();
        if (issueStatuses != null) {
            for (Status issueStatus : issueStatuses) {
                if (!issueStatus.getName().equalsIgnoreCase(status)) continue;
                return Promises.promise(issueStatus);
            }
        }
        return Promises.promise(null);
    }

    @Override
    public Promise<Priority> getPriority(String priority) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("priority").build(new Object[0]);
        Iterable issuePriorities = (Iterable)this.getAndParse(uri, this.prioritiesJsonParser).claim();
        if (issuePriorities != null) {
            for (Priority issuePriority : issuePriorities) {
                if (!issuePriority.getName().equalsIgnoreCase(priority)) continue;
                return Promises.promise(issuePriority);
            }
        }
        return Promises.promise(null);
    }

    @Override
    public Promise<Resolution> getResolution(String resolution) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("resolution").build(new Object[0]);
        Iterable issueResolutions = (Iterable)this.getAndParse(uri, this.resolutionsJsonParser).claim();
        if (issueResolutions != null) {
            for (Resolution issueResolution : issueResolutions) {
                if (!issueResolution.getName().equalsIgnoreCase(resolution)) continue;
                return Promises.promise(issueResolution);
            }
        }
        return Promises.promise(null);
    }
}

