/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.internal.client;

import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SessionRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.internal.async.AsynchronousIssueRestClient;
import com.atlassian.jira.rest.client.internal.json.gen.IssueInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.perforce.p4dtg.plugin.jira.rest.client.ExtendedIssueRestClient;
import io.atlassian.util.concurrent.Promise;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;

public class AsynchronousExtendedIssueRestClient
extends AsynchronousIssueRestClient
implements ExtendedIssueRestClient {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final HttpClient client;

    public AsynchronousExtendedIssueRestClient(URI baseUri, HttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(baseUri, client, sessionRestClient, metadataRestClient);
        this.client = client;
    }

    @Override
    public Promise<Void> update(URI issueUri, IssueInput issueInput) {
        return this.put(issueUri, issueInput, new IssueInputJsonGenerator());
    }

    @Override
    public Promise<Void> update(Issue issue, IssueInput issueInput) {
        return this.update(issue.getSelf(), issueInput);
    }

    private <T> EntityBuilder toEntity(final JsonGenerator<T> generator, final T bean) {
        return new EntityBuilder(){

            @Override
            public EntityBuilder.Entity build() {
                return new EntityBuilder.Entity(){

                    @Override
                    public Map<String, String> getHeaders() {
                        return Collections.singletonMap("Content-Type", AsynchronousExtendedIssueRestClient.JSON_CONTENT_TYPE);
                    }

                    @Override
                    public InputStream getInputStream() {
                        try {
                            return new ByteArrayInputStream(generator.generate(bean).toString().getBytes(Charset.forName("UTF-8")));
                        }
                        catch (JSONException e) {
                            throw new RestClientException(e);
                        }
                    }
                };
            }
        };
    }
}

