/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.client;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.ComponentRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.ProjectRestClient;
import com.atlassian.jira.rest.client.api.ProjectRolesRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.SessionRestClient;
import com.atlassian.jira.rest.client.api.UserRestClient;
import com.atlassian.jira.rest.client.api.VersionRestClient;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClient;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.perforce.p4dtg.plugin.jira.rest.client.BearerHttpAuthenticationHandler;
import com.perforce.p4dtg.plugin.jira.rest.client.ExtendedIssueRestClient;
import com.perforce.p4dtg.plugin.jira.rest.client.ExtendedMetadataRestClient;
import com.perforce.p4dtg.plugin.jira.rest.client.P4AsynchronousHttpClientFactory;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.AsynchronousExtendedIssueRestClient;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.AsynchronousExtendedMetadataRestClient;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGAsynchronousSearchRestClient;
import com.perforce.p4dtg.plugin.jira.rest.internal.client.P4DTGSearchRestClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.UriBuilder;

public class RestClientManager {
    private static final Logger logger = Logger.getLogger(RestClientManager.class.getPackage().getName());
    private static final String DEFAULT_URL_PATH = "/rest/api/latest";
    private JiraRestClient jiraRestClient = null;
    private SearchRestClient searchClient = null;
    private P4DTGSearchRestClient searchJqlClient = null;
    private SessionRestClient sessionClient = null;
    private UserRestClient userClient = null;
    private ProjectRestClient projectClient = null;
    private ProjectRolesRestClient projectRolesRestClient = null;
    private ExtendedIssueRestClient extendedIssueClient = null;
    private ComponentRestClient componentClient = null;
    private VersionRestClient versionRestClient = null;
    private ExtendedMetadataRestClient extendedMetadataClient = null;
    private String serverUri = null;
    private String username = null;
    private String password = null;
    private String url_path = "/rest/api/latest";

    public RestClientManager(String serverUri, String username, String password) throws URISyntaxException {
        this(serverUri, username, password, null, null);
    }

    public RestClientManager(String serverUri, String username, String password, String trustStorePath, String trustStorePassword) throws URISyntaxException {
        if (trustStorePath != null) {
            System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        }
        if (trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
        this.serverUri = serverUri;
        this.username = username;
        this.password = password;
        URI serverUriObject = new URI(serverUri);
        P4AsynchronousHttpClientFactory cf = new P4AsynchronousHttpClientFactory();
        DisposableHttpClient timeoutClient = cf.createClient(serverUriObject, this.getAuthHandler());
        this.jiraRestClient = new AsynchronousJiraRestClient(serverUriObject, timeoutClient);
        this.sessionClient = this.jiraRestClient.getSessionClient();
        this.userClient = this.jiraRestClient.getUserClient();
        this.projectClient = this.jiraRestClient.getProjectClient();
        this.componentClient = this.jiraRestClient.getComponentClient();
        this.searchClient = this.jiraRestClient.getSearchClient();
        this.searchJqlClient = new P4DTGAsynchronousSearchRestClient(serverUriObject, timeoutClient);
        this.versionRestClient = this.jiraRestClient.getVersionRestClient();
        this.projectRolesRestClient = this.jiraRestClient.getProjectRolesRestClient();
        URI baseUri = UriBuilder.fromUri(serverUri).path(this.url_path).build(new Object[0]);
        DisposableHttpClient httpClient = new P4AsynchronousHttpClientFactory().createClient(serverUriObject, this.getAuthHandler());
        this.extendedMetadataClient = new AsynchronousExtendedMetadataRestClient(baseUri, httpClient);
        this.extendedIssueClient = new AsynchronousExtendedIssueRestClient(baseUri, httpClient, this.sessionClient, this.extendedMetadataClient);
    }

    public boolean isJiraCloudURL() {
        return this.serverUri != null && this.serverUri.contains(".atlassian.net");
    }

    private static void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Exception occurred while initializing SSL context.", e);
        }
    }

    private AuthenticationHandler getAuthHandler() {
        AuthenticationHandler authHandler = "".equals(this.username) || "*".equals(this.username) ? new BearerHttpAuthenticationHandler(this.password) : new BasicHttpAuthenticationHandler(this.username, this.password);
        return authHandler;
    }

    public void dispose() throws IOException {
        this.jiraRestClient.close();
    }

    public ExtendedIssueRestClient getExtendedIssueClient() {
        return this.extendedIssueClient;
    }

    public void setExtendedIssueClient(ExtendedIssueRestClient extendedIssueClient) {
        this.extendedIssueClient = extendedIssueClient;
    }

    public SessionRestClient getSessionClient() {
        return this.sessionClient;
    }

    public void setSessionClient(SessionRestClient sessionClient) {
        this.sessionClient = sessionClient;
    }

    public UserRestClient getUserClient() {
        return this.userClient;
    }

    public void setUserClient(UserRestClient userClient) {
        this.userClient = userClient;
    }

    public ProjectRestClient getProjectClient() {
        return this.projectClient;
    }

    public void setProjectClient(ProjectRestClient projectClient) {
        this.projectClient = projectClient;
    }

    public ComponentRestClient getComponentClient() {
        return this.componentClient;
    }

    public void setComponentClient(ComponentRestClient componentClient) {
        this.componentClient = componentClient;
    }

    public ExtendedMetadataRestClient getExtendedMetadataClient() {
        return this.extendedMetadataClient;
    }

    public void setExtendedMetadataClient(ExtendedMetadataRestClient extendedMetadataClient) {
        this.extendedMetadataClient = extendedMetadataClient;
    }

    public SearchRestClient getSearchClient() {
        return this.searchClient;
    }

    public void setSearchClient(SearchRestClient searchClient) {
        this.searchClient = searchClient;
    }

    public P4DTGSearchRestClient getSearchJqlClient() {
        return this.searchJqlClient;
    }

    public void setSearchJqlClient(P4DTGSearchRestClient searchJqlClient) {
        this.searchJqlClient = searchJqlClient;
    }

    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    public void setVersionRestClient(VersionRestClient versionRestClient) {
        this.versionRestClient = versionRestClient;
    }

    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }

    public void setProjectRolesRestClient(ProjectRolesRestClient projectRolesRestClient) {
        this.projectRolesRestClient = projectRolesRestClient;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

