/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.rest.client;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import com.atlassian.jira.rest.client.internal.async.AtlassianHttpClientDecorator;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class P4AsynchronousHttpClientFactory
extends AsynchronousHttpClientFactory {
    private static Integer socketTimeout = null;
    private static Integer requestTimeout = null;
    private static Integer connectionTimeout = null;
    private static final Logger logger = Logger.getLogger(P4AsynchronousHttpClientFactory.class.getPackage().getName());

    public static void setSocketTimeout(int socketTimeout) {
        P4AsynchronousHttpClientFactory.socketTimeout = socketTimeout;
        logger.log(Level.INFO, "Setting Socket Timeout to {0} seconds.", socketTimeout);
    }

    public static void setRequestTimeout(int requestTimeout) {
        P4AsynchronousHttpClientFactory.requestTimeout = requestTimeout;
        logger.log(Level.INFO, "Setting Request Timeout to {0} seconds.", requestTimeout);
    }

    public static void setConnectionTimeout(int connectionTimeout) {
        P4AsynchronousHttpClientFactory.connectionTimeout = connectionTimeout;
        logger.log(Level.INFO, "Setting Connection Timeout to {0} seconds.", connectionTimeout);
    }

    @Override
    public DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        HttpClientOptions options = new HttpClientOptions();
        if (socketTimeout != null) {
            options.setSocketTimeout(socketTimeout, TimeUnit.SECONDS);
        }
        if (requestTimeout != null) {
            options.setRequestTimeout(requestTimeout, TimeUnit.SECONDS);
        }
        if (connectionTimeout != null) {
            options.setConnectionTimeout(connectionTimeout, TimeUnit.SECONDS);
        }
        final DefaultHttpClientFactory defaultHttpClientFactory = new DefaultHttpClientFactory(new NoOpEventPublisher(), new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            @Override
            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new AtlassianHttpClientDecorator(httpClient, authenticationHandler){

            @Override
            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    private static class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        @Override
        public String getApplicationFileEncoding() {
            return "UTF8";
        }

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        @Nonnull
        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return "P4DTG P4 Atlassian JIRA Rest Java Client";
        }

        @Override
        @Nonnull
        public String getPlatformId() {
            return "jira";
        }

        @Override
        @Nonnull
        public String getVersion() {
            return "P4 2021.2";
        }

        @Override
        @Nonnull
        public Date getBuildDate() {
            return new Date(2022, 4, 1);
        }

        @Override
        @Nonnull
        public String getBuildNumber() {
            return String.valueOf(0);
        }

        @Override
        public File getHomeDirectory() {
            return new File(".");
        }

        @Override
        public String getPropertyValue(String s2) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Optional<Path> getLocalHomeDirectory() {
            return Optional.empty();
        }

        @Override
        public Optional<Path> getSharedHomeDirectory() {
            return Optional.empty();
        }
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        @Override
        public void publish(Object o) {
        }

        @Override
        public void register(Object o) {
        }

        @Override
        public void unregister(Object o) {
        }

        @Override
        public void unregisterAll() {
        }
    }
}

