/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.config;

import com.perforce.p4dtg.plugin.jira.config.Base;
import com.perforce.p4dtg.plugin.jira.config.CustomField;
import com.perforce.p4dtg.plugin.jira.config.Option;
import com.perforce.p4dtg.plugin.jira.config.ResolutionTransition;
import com.perforce.p4dtg.plugin.jira.config.Step;
import com.perforce.p4dtg.plugin.jira.config.Transition;
import com.perforce.p4dtg.plugin.jira.config.Workflow;
import com.perforce.p4dtg.plugin.jira.rest.client.P4AsynchronousHttpClientFactory;
import com.perforce.p4dtg.plugin.jira.tcp.internal.request.UserNameHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configuration {
    private static final Logger logger = Logger.getLogger(Configuration.class.getPackage().getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONFIG_XML_FILE = System.getProperty("javadts.XML_FILE", "config/jira-rest-config.xml");
    private List<CustomField> customFields = null;
    private List<Workflow> workflows = null;
    private String xmlFile = null;
    private Document dom = null;
    private Map<String, Map<String, String>> workflowMap = null;
    private final Map<String, String> jiraHandling = new HashMap<String, String>();
    public static final String IGNORE_PROJECTS = "IgnoreProjects";
    public static final String QUERY_STYLE = "QueryStyle";
    public static final String USER_NAME_STYLE = "UserStyle";
    public static final String USER_NAME_STYLE_DEFAULT = "name,email,emailshort,displayname";
    public static final String SOCKET_TIMEOUT_SECONDS = "SocketTimeoutSeconds";
    public static final String REQUEST_TIMEOUT_SECONDS = "RequestTimeoutSeconds";
    public static final String CONNECTION_TIMEOUT_SECONDS = "ConnectionTimeoutSeconds";
    private final String[] jiraHandlingElements = new String[]{"IgnoreProjects", "QueryStyle", "UserStyle", "SocketTimeoutSeconds", "RequestTimeoutSeconds", "ConnectionTimeoutSeconds"};
    private Map<String, String> ignoredProjects;
    private String[] userStyles;

    public Map<String, Map<String, String>> getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(Map<String, Map<String, String>> workflowMap) {
        this.workflowMap = workflowMap;
    }

    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    public List<Workflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(List<Workflow> workflows) {
        this.workflows = workflows;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void setJiraHandling(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Configuration.setJiraHandling key must not be null.");
        }
        this.jiraHandling.put(key, value);
    }

    public String getJiraHandling(String key) {
        return this.jiraHandling.get(key);
    }

    public Configuration(String configFile) throws Exception {
        if (configFile != null) {
            this.xmlFile = configFile;
        } else {
            this.xmlFile = CONFIG_XML_FILE;
            logger.log(Level.INFO, "The JIRA config file is not specified. The default jira-rest-config.xml file will be used.");
        }
        File file = new File(this.xmlFile);
        if (!file.exists()) {
            throw new Exception("The JIRA config file " + configFile + " does not exist.");
        }
        this.customFields = new ArrayList<CustomField>();
        this.workflows = new ArrayList<Workflow>();
        this.workflowMap = new HashMap<String, Map<String, String>>();
    }

    public void parse() throws Exception {
        this.parseXmlFile();
        this.parseDocument();
        if (this.workflows == null || this.workflows.isEmpty()) {
            throw new Exception("There are no workflows parsed from the JIRA config file.");
        }
        this.validate();
        this.buildResolutionStatusMap();
        UserNameHelper.setConfiguration(this);
    }

    private void validate() throws Exception {
        if (this.workflows != null) {
            HashMap<String, Map<String, String>> transitionMap = new HashMap<String, Map<String, String>>();
            for (Workflow workflow : this.workflows) {
                if (workflow == null) continue;
                List<Step> steps = workflow.getSteps();
                this.validateSteps(steps, transitionMap);
            }
        }
        String[] stylesDefault = USER_NAME_STYLE_DEFAULT.toLowerCase().split(",");
        String stylesString = this.getJiraHandling(USER_NAME_STYLE);
        if (stylesString == null || stylesString.length() < 1) {
            this.userStyles = stylesDefault;
        } else {
            this.userStyles = stylesString.split(",");
            UserNameHelper.validateConfig(this.userStyles, stylesDefault);
        }
    }

    private void validateSteps(List<Step> steps, Map<String, Map<String, String>> transitionMap) throws Exception {
        if (steps != null) {
            for (Step step : steps) {
                if (step == null) continue;
                List<Transition> transitions = step.getTransitions();
                this.validateTransitions(transitions, transitionMap);
            }
        }
    }

    private void validateTransitions(List<Transition> transitions, Map<String, Map<String, String>> transitionMap) throws Exception {
        if (transitions != null) {
            for (Transition transition : transitions) {
                if (transition == null) continue;
                String name = transition.getName();
                String destStep = transition.getDestinationStep();
                if (this.isEmpty(name) || this.isEmpty(destStep)) continue;
                Map<String, String> destStepMap = transitionMap.get(name);
                if (destStepMap == null) {
                    destStepMap = new HashMap<String, String>();
                }
                destStepMap.put(destStep, destStep);
                transitionMap.put(name, destStepMap);
                if (destStepMap.keySet().size() <= 1) continue;
                StringBuilder sb = new StringBuilder();
                for (String key : destStepMap.keySet()) {
                    if (key == null) continue;
                    sb.append(" '").append(key).append("'");
                }
                throw new Exception("JIRA config file error: Transition '" + name + "' have different destination steps:" + sb.toString());
            }
        }
    }

    private void buildResolutionStatusMap() {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        if (this.workflows != null) {
            for (Workflow workflow : this.workflows) {
                if (workflow == null) continue;
                List<ResolutionTransition> resolutionTransitions = workflow.getResolutionTransitions();
                this.buildResolutionTransitionStatusMap(workflow, resolutionTransitions, statusMap);
            }
        }
        this.workflowMap.put("resolutionStatus", statusMap);
    }

    private void buildResolutionTransitionStatusMap(Workflow workflow, List<ResolutionTransition> resolutionTransitions, Map<String, String> statusMap) {
        if (resolutionTransitions != null) {
            for (ResolutionTransition resolutionTransition : resolutionTransitions) {
                String status;
                String stepName;
                String transitionName = resolutionTransition.getName();
                if (transitionName == null || (stepName = this.getStepForTransitionName(workflow, transitionName)) == null || (status = this.getStatusForStep(workflow, stepName)) == null) continue;
                statusMap.put(status, status);
            }
        }
    }

    protected String getStepForTransitionName(Workflow workflow, String transitionName) {
        List<Step> steps;
        if (transitionName != null && workflow != null && (steps = workflow.getSteps()) != null) {
            for (Step step : steps) {
                List<Transition> transitions;
                if (step == null || (transitions = step.getTransitions()) == null) continue;
                for (Transition transition : transitions) {
                    String name;
                    if (transition == null || (name = transition.getName()) == null || !name.equalsIgnoreCase(transitionName)) continue;
                    return transition.getDestinationStep();
                }
            }
        }
        return null;
    }

    protected String getStatusForStep(Workflow workflow, String stepName) {
        List<Step> steps;
        if (workflow != null && stepName != null && (steps = workflow.getSteps()) != null) {
            for (Step step : steps) {
                String name;
                if (step == null || (name = step.getName()) == null || !name.equalsIgnoreCase(stepName)) continue;
                return step.getLinkedStatus();
            }
        }
        return null;
    }

    private void parseXmlFile() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.xmlFile);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "ParserConfigurationException parsing the JIRA REST config XML file.", e);
            throw new Exception("ParserConfigurationException occurred while parsing the JIRA REST config file.", e);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "SAXException parsing the JIRA REST config XML file.", e);
            throw new Exception("SAXException occurred while parsing the JIRA REST config file.", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "OException parsing the JIRA REST config XML file.", e);
            throw new Exception("IOException occurred while parsing the JIRA REST config file.", e);
        }
    }

    private void parseDocument() throws Exception {
        NodeList nlist;
        Element element = this.dom.getDocumentElement();
        NodeList nl = element.getElementsByTagName("CustomField");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                CustomField cf = this.getCustomField(e);
                this.customFields.add(cf);
            }
        }
        if ((nlist = element.getElementsByTagName("Workflow")) != null && nlist.getLength() > 0) {
            for (int i = 0; i < nlist.getLength(); ++i) {
                Element e = (Element)nlist.item(i);
                Workflow wf = this.getWorkflow(e);
                this.workflows.add(wf);
            }
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        block10: for (String lookFor : this.jiraHandlingElements) {
            String find = "/Config/JiraHandling/" + lookFor + "/text()";
            String val = xPath.evaluate(find, this.dom);
            if (val == null || !(val instanceof String)) continue;
            String textVal = val;
            textVal = textVal.replaceAll("\\s+", "");
            switch (lookFor) {
                case "SocketTimeoutSeconds": 
                case "RequestTimeoutSeconds": 
                case "ConnectionTimeoutSeconds": {
                    boolean isValid = this.setTimeout(textVal, lookFor);
                    if (!isValid) continue block10;
                }
                default: {
                    this.jiraHandling.put(lookFor, textVal);
                }
            }
        }
    }

    private boolean setTimeout(String textVal, String lookFor) {
        int timeOut;
        if (textVal.length() < 1) {
            return false;
        }
        try {
            timeOut = Integer.parseInt(textVal);
        }
        catch (NumberFormatException e) {
            logger.log(Level.INFO, "The config file value for JiraHandling/{0} has non integer: \"{1}\"; Using Jira Default.", new Object[]{lookFor, textVal});
            return false;
        }
        if (timeOut < 1) {
            logger.log(Level.INFO, "The config file value for JiraHandling/{0} must be > 0.  Value: {1}; Using Jira Default.", new Object[]{lookFor, textVal});
            return false;
        }
        switch (lookFor) {
            case "SocketTimeoutSeconds": {
                P4AsynchronousHttpClientFactory.setSocketTimeout(timeOut);
                break;
            }
            case "RequestTimeoutSeconds": {
                P4AsynchronousHttpClientFactory.setRequestTimeout(timeOut);
                break;
            }
            case "ConnectionTimeoutSeconds": {
                P4AsynchronousHttpClientFactory.setConnectionTimeout(timeOut);
            }
        }
        return true;
    }

    public boolean isIgnoredProject(String projId) {
        if (this.ignoredProjects == null) {
            String[] projects;
            this.ignoredProjects = new HashMap<String, String>();
            String projList = this.getJiraHandling(IGNORE_PROJECTS);
            if (projList == null) {
                return false;
            }
            for (String project : projects = projList.split(",")) {
                if (project.length() <= 0) continue;
                this.ignoredProjects.put(project, project);
            }
        }
        return this.ignoredProjects.containsKey(projId);
    }

    public String[] getUserStyles() {
        return this.userStyles;
    }

    private CustomField getCustomField(Element element) throws Exception {
        ArrayList<Option> options = new ArrayList<Option>();
        String name = this.getTextValue(element, "name");
        String access = this.getTextValue(element, "access");
        String type = this.getTextValue(element, "type");
        NodeList nl = element.getElementsByTagName("Option");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                Option o = this.getOption(e);
                options.add(o);
            }
        }
        if (options.isEmpty()) {
            options = null;
        }
        CustomField cf = new CustomField(name, access, type, options);
        return cf;
    }

    private Option getOption(Element element) throws Exception {
        String value = this.getTextValue(element, "value");
        Option opt = new Option(value, value);
        return opt;
    }

    private Workflow getWorkflow(Element element) throws Exception {
        Element e;
        int i;
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<ResolutionTransition> resolutionTransitions = new ArrayList<ResolutionTransition>();
        String name = this.getTextValue(element, "name");
        NodeList nl = element.getElementsByTagName("Step");
        if (nl != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                e = (Element)nl.item(i);
                Step s2 = this.getStep(e);
                steps.add(s2);
            }
        }
        if ((nl = element.getElementsByTagName("ResolutionTransition")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                e = (Element)nl.item(i);
                ResolutionTransition rt = this.getResolutionTransition(e);
                resolutionTransitions.add(rt);
            }
        }
        Workflow wf = new Workflow(name, steps, resolutionTransitions);
        return wf;
    }

    private ResolutionTransition getResolutionTransition(Element element) throws Exception {
        String name = this.getTextValue(element, "name");
        ResolutionTransition rt = new ResolutionTransition(name);
        return rt;
    }

    private Step getStep(Element element) throws Exception {
        ArrayList<Transition> transitioins = new ArrayList<Transition>();
        String name = this.getTextValue(element, "name");
        String linkedStatus = this.getTextValue(element, "linkedStatus");
        NodeList nl = element.getElementsByTagName("Transition");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                Transition t2 = this.getTransition(e);
                transitioins.add(t2);
            }
        }
        Step s2 = new Step(name, linkedStatus, transitioins);
        return s2;
    }

    private Transition getTransition(Element element) throws Exception {
        String name = this.getTextValue(element, "name");
        String destinationStep = this.getTextValue(element, "destinationStep");
        Transition t2 = new Transition(name, destinationStep);
        return t2;
    }

    private String getTextValue(Element element, String tag) {
        NodeList nl;
        String textVal = element.getAttribute(tag);
        if (this.isEmpty(textVal) && (nl = element.getElementsByTagName(tag)) != null && nl.getLength() > 0) {
            Element e = (Element)nl.item(0);
            textVal = e.getFirstChild().getNodeValue();
        }
        if (textVal != null) {
            textVal = textVal.trim();
            textVal = textVal.replaceAll("\\s+", " ");
        }
        return textVal == null ? "" : textVal;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("******** User Defined Configurations ********").append(LINE_SEPARATOR);
        sb.append("========== Custom fields ==========").append(LINE_SEPARATOR);
        if (this.customFields != null) {
            for (CustomField customField : this.customFields) {
                if (customField == null) continue;
                sb.append("--- customField:").append(customField.toString()).append(LINE_SEPARATOR);
            }
        }
        sb.append("========= Workflows =========").append(LINE_SEPARATOR);
        if (this.workflows != null) {
            for (Workflow workflow : this.workflows) {
                if (workflow == null) continue;
                sb.append("--- workflow: ---").append(LINE_SEPARATOR);
                sb.append(workflow.toString());
                sb.append("---------------").append(LINE_SEPARATOR);
            }
        }
        sb.append("=========== JiraHandling ==========").append(LINE_SEPARATOR);
        for (Iterator<Base> iterator : this.jiraHandlingElements) {
            String value = this.jiraHandling.get(iterator);
            sb.append((String)((Object)iterator)).append(" = '").append(value != null ? value : "").append("'").append(LINE_SEPARATOR);
        }
        sb.append("***********************************").append(LINE_SEPARATOR);
        return sb.toString();
    }
}

