/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4dtg.plugin.jira.common;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class Utils {
    public static Date parseDate(String date, String pattern) throws ParseException {
        Date d = null;
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            d = df.parse(date);
        }
        return d;
    }

    public static Calendar parseCalendar(String date, String pattern) throws ParseException {
        Date d;
        Calendar cal = null;
        if (date != null && (d = Utils.parseDate(date, pattern)) != null) {
            cal = Calendar.getInstance();
            cal.setTime(d);
        }
        return cal;
    }

    public static String formatDate(Date date, String pattern) {
        String d = null;
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            d = df.format(date);
        }
        return d;
    }

    public static String getMapValue(Map<String, String[]> map, String key) {
        String[] values;
        if (map != null && key != null && (values = map.get(key)) != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String getIdFromUri(URI uri) {
        if (uri != null) {
            String path = uri.getPath();
            String id = path.substring(path.lastIndexOf(47) + 1);
            return id;
        }
        return null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isEmpty(String[] values) {
        if (values != null && values.length > 0) {
            return Utils.isEmpty(values[0]);
        }
        return true;
    }

    public static String guardNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static int getErrorStatus(RestClientException exc) {
        Collection<ErrorCollection> errs = exc.getErrorCollections();
        Iterator<ErrorCollection> iterator = errs.iterator();
        if (iterator.hasNext()) {
            ErrorCollection err = iterator.next();
            return err.getStatus();
        }
        return 0;
    }
}

