/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.SizeGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SizeGroupComponentWrapper
extends JPanel {
    private final JComponent component;
    private SizeGroup sizeGroup;

    public SizeGroupComponentWrapper(JComponent component) {
        this.component = component;
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SizeGroupComponentWrapper.this.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                SizeGroupComponentWrapper.this.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)component, "Center");
        this.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.getIntrinsicPreferredSize();
        if (this.sizeGroup != null) {
            if (this.sizeGroup.isCommonWidth()) {
                preferredSize.width = this.sizeGroup.getCommonWidth();
            }
            if (this.sizeGroup.isCommonHeight()) {
                preferredSize.height = this.sizeGroup.getCommonHeight();
            }
        }
        return preferredSize;
    }

    public Dimension getIntrinsicPreferredSize() {
        return this.component.getPreferredSize();
    }

    public void setSizeGroup(SizeGroup sizeGroup) {
        this.sizeGroup = sizeGroup;
    }

    protected JComponent getComponent() {
        return this.component;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.getComponent().getBaseline(width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return this.getComponent().getBaselineResizeBehavior();
    }
}

