/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.update.UpdateSchedule;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class UpdateScheduleRegistryImpl {
    private static final String REGVAL_PREFIX_UPDATE_SCHEDULE = "updateSchedule";
    private static final String REGVAL_PREFIX_LAST_UPDATE = "lastUpdate";

    private UpdateScheduleRegistryImpl() {
    }

    public static boolean checkAndReset() {
        UpdateSchedule updateSchedule = UpdateScheduleRegistryImpl.getUpdateSchedule();
        if (updateSchedule == null || updateSchedule == UpdateSchedule.NEVER) {
            return false;
        }
        Date lastUpdateCheckDate = UpdateScheduleRegistryImpl.getLastUpdateCheckDate();
        if (lastUpdateCheckDate == null || updateSchedule == UpdateSchedule.ON_EVERY_START) {
            UpdateScheduleRegistryImpl.checkedForUpdate();
            return true;
        }
        Calendar now = Calendar.getInstance();
        Calendar updateCheck = Calendar.getInstance();
        updateCheck.setTime(lastUpdateCheckDate);
        updateCheck.add(UpdateScheduleRegistryImpl.getField(updateSchedule), 1);
        if (updateCheck.before(now)) {
            UpdateScheduleRegistryImpl.checkedForUpdate();
            return true;
        }
        return false;
    }

    private static int getField(UpdateSchedule updateSchedule) {
        if (updateSchedule == UpdateSchedule.DAILY) {
            return 5;
        }
        if (updateSchedule == UpdateSchedule.WEEKLY) {
            return 3;
        }
        if (updateSchedule == UpdateSchedule.MONTHLY) {
            return 2;
        }
        return -1;
    }

    public static Date getLastUpdateCheckDate() {
        String applicationId = UpdateScheduleRegistryImpl.getApplicationId();
        if (applicationId == null) {
            return null;
        }
        String value = InstallRegistry.getValue(REGVAL_PREFIX_LAST_UPDATE + applicationId);
        if (value == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkedForUpdate() {
        String applicationId = UpdateScheduleRegistryImpl.getApplicationId();
        if (applicationId == null) {
            return;
        }
        InstallRegistry.setValue(REGVAL_PREFIX_LAST_UPDATE + applicationId, String.valueOf(new Date().getTime()));
    }

    public static void setUpdateSchedule(UpdateSchedule updateSchedule) {
        String applicationId = UpdateScheduleRegistryImpl.getApplicationId();
        if (applicationId == null) {
            return;
        }
        InstallRegistry.setValue(REGVAL_PREFIX_UPDATE_SCHEDULE + applicationId, updateSchedule.getId());
    }

    public static UpdateSchedule getUpdateSchedule() {
        String applicationId = UpdateScheduleRegistryImpl.getApplicationId();
        if (applicationId == null) {
            return null;
        }
        return UpdateSchedule.getById(InstallRegistry.getValue(REGVAL_PREFIX_UPDATE_SCHEDULE + applicationId));
    }

    public static String getApplicationId() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            try {
                installerConfig = InstallerConfig.getGeneralConfigFromFile(new File(ResourceHelper.getRuntimeDir(), "i4jparams.conf"));
            }
            catch (IOException e) {
                if (System.getProperty("install4j.launcherId") != null) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return installerConfig.getApplicationId();
    }
}

