/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.GroupType;
import com.install4j.api.formcomponents.LayoutGroup;
import com.install4j.runtime.beans.groups.FormComponentGroup;
import com.install4j.runtime.installer.config.FormComponentProvider;
import com.install4j.runtime.installer.config.GroupProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LayoutGroupImpl
implements LayoutGroup {
    private GroupProvider groupProvider;
    private List<?> children;

    public static List<?> createChildren(List<?> beanConfigs) {
        ArrayList<Object> children = new ArrayList<Object>(beanConfigs.size());
        for (Object bean : beanConfigs) {
            if (bean instanceof GroupProvider) {
                children.add(new LayoutGroupImpl((GroupProvider)bean));
                continue;
            }
            if (!(bean instanceof FormComponentProvider)) continue;
            children.add(((FormComponentProvider)bean).getFormComponent());
        }
        return Collections.unmodifiableList(children);
    }

    public static LayoutGroup findLayoutGroupById(String id, List<?> beans) {
        for (Object bean : beans) {
            if (!(bean instanceof LayoutGroup)) continue;
            LayoutGroupImpl layoutGroup = (LayoutGroupImpl)bean;
            if (layoutGroup.getId().equals(id) || layoutGroup.getInternalId().equals(id)) {
                return layoutGroup;
            }
            LayoutGroup descendantGroup = LayoutGroupImpl.findLayoutGroupById(id, layoutGroup.getChildren());
            if (descendantGroup == null) continue;
            return descendantGroup;
        }
        return null;
    }

    public LayoutGroupImpl(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
        this.children = LayoutGroupImpl.createChildren(groupProvider.getBeanConfigs());
    }

    @Override
    public GroupType getGroupType() {
        return this.getGroup().getGroupType();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getGroup().setEnabled(enabled);
        for (Object bean : this.children) {
            if (bean instanceof LayoutGroup) {
                ((LayoutGroup)bean).setEnabled(enabled);
                continue;
            }
            if (!(bean instanceof FormComponent)) continue;
            ((FormComponent)bean).setEnabled(enabled);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.getGroup().setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.getGroup().isVisible();
    }

    @Override
    public String getId() {
        return this.groupProvider.getDisplayedId();
    }

    public String getInternalId() {
        return this.groupProvider.getId();
    }

    @Override
    public List<?> getChildren() {
        return this.children;
    }

    public GroupProvider getGroupProvider() {
        return this.groupProvider;
    }

    public FormComponentGroup getGroup() {
        return (FormComponentGroup)this.groupProvider.getOrInstantiateBean();
    }
}

