/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.NotSupportedInElevationException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.formcomponents.GroupType;
import com.install4j.api.formcomponents.LayoutGroup;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentTextBinder;
import com.install4j.runtime.beans.groups.TabGroup;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.VariableReplacer;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.LayoutGroupImpl;
import com.install4j.runtime.util.ObjectUtil;
import com.install4j.runtime.util.StringUtil;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class FormEnvironmentImpl
implements FormEnvironment,
VariableReplacer {
    private FormPanel formPanel;
    private FormComponent[] formComponents;
    private String[] ids;
    private String[] displayedIds;
    private ComponentTuple[] componentTuples;
    private List<?> formComponentTree;
    private Map<String, Object> formVariables = Collections.synchronizedMap(new TreeMap());
    private List<String> replacementRecording;
    private FormEnvironmentTextBinder textBinder = new FormEnvironmentTextBinder(this);
    private boolean initialized;

    public FormEnvironmentImpl(FormPanel formPanel, FormComponent[] formComponents, String[] ids, String[] displayedIds, ComponentTuple[] componentTuples, List<?> beanConfigs, boolean initialized) {
        this.formPanel = formPanel;
        this.formComponents = formComponents;
        this.ids = ids;
        this.displayedIds = displayedIds;
        this.componentTuples = componentTuples;
        this.formComponentTree = LayoutGroupImpl.createChildren(beanConfigs);
        this.initialized = initialized;
    }

    @Override
    public FormComponent[] getFormComponents() {
        return this.formComponents;
    }

    @Override
    public List<?> getFormComponentTree() {
        return this.formComponentTree;
    }

    @Override
    public String getId(FormComponent formComponent) {
        int index = this.getIndex(this.formComponents, formComponent);
        if (index < 0) {
            return null;
        }
        return this.displayedIds[index];
    }

    @Override
    public <T> T[] getFormComponents(Class<T> formComponentClass) {
        ArrayList<T> formComponents = new ArrayList<T>();
        for (FormComponent formComponent : this.getFormComponents()) {
            if (!formComponentClass.isAssignableFrom(formComponent.getClass())) continue;
            formComponents.add(formComponentClass.cast(formComponent));
        }
        return ObjectUtil.toTypedArray(formComponents, formComponentClass);
    }

    @Override
    public <T> T getFirstFormComponent(Class<T> formComponentClass) throws NotSupportedInElevationException {
        for (FormComponent formComponent : this.formComponents) {
            if (!formComponentClass.isAssignableFrom(formComponent.getClass())) continue;
            return formComponentClass.cast(formComponent);
        }
        return null;
    }

    @Override
    public FormComponent getFormComponentById(String id) {
        int index = this.getIndex(this.ids, id);
        if (index < 0) {
            index = this.getIndex(this.displayedIds, id);
        }
        if (index < 0) {
            return null;
        }
        return this.formComponents[index];
    }

    @Override
    public LayoutGroup getLayoutGroupById(String id) {
        return LayoutGroupImpl.findLayoutGroupById(id, this.formComponentTree);
    }

    @Override
    public ComponentTuple getComponentTuple(FormComponent formComponent) {
        int index = this.getIndex(this.formComponents, formComponent);
        if (index < 0) {
            return null;
        }
        return this.componentTuples[index];
    }

    @Override
    public void scrollComponentToVisible(FormComponent formComponent) {
        EventQueue.invokeLater(() -> {
            ComponentTuple componentTuple = this.getComponentTuple(formComponent);
            JComponent c = componentTuple.getCenterComponent();
            if (c == null) {
                return;
            }
            ScrollablePanel panel = (ScrollablePanel)SwingUtilities.getAncestorOfClass(ScrollablePanel.class, c);
            if (panel == null) {
                return;
            }
            Rectangle rect = SwingUtilities.convertRectangle(c.getParent(), c.getBounds(), panel);
            c.scrollRectToVisible(rect);
        });
    }

    @Override
    public boolean isDesignTime() {
        return false;
    }

    @Override
    public void addDesignTimeChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void removeDesignTimeChangeListener(ChangeListener changeListener) {
    }

    @Override
    public String getDesignTimeName(FormComponent formComponent) {
        return null;
    }

    @Override
    public String getDesignTimeName(LayoutGroup layoutGroup) {
        return null;
    }

    @Override
    public Screen getScreen() {
        return this.formPanel.getScreen();
    }

    @Override
    public void resetFormComponents() {
        this.formPanel.previous();
    }

    @Override
    public void reinitializeFormComponents() {
        this.formPanel.reinitializeComponents();
    }

    @Override
    public boolean saveFormComponents() {
        return this.formPanel.checkCompleted();
    }

    @Override
    public void makeParentGroupVisible(FormComponent formComponent) {
        this.makeParentGroupVisible(formComponent, this.formComponentTree);
    }

    @Override
    public void bindTextWithVariables(String textWithVariables, JComponent componentWithText) {
        this.textBinder.bind(textWithVariables, componentWithText);
    }

    @Override
    public Object getFormVariable(String variableName) {
        if (this.replacementRecording != null) {
            this.replacementRecording.add("form:" + variableName);
        }
        return this.formVariables.get(variableName);
    }

    @Override
    public void setFormVariable(String variableName, Object value) {
        this.formVariables.put(variableName, value);
        this.textBinder.formVariableChanged(variableName);
    }

    @Override
    public Set<String> getFormVariableNames() {
        return new HashSet<String>(this.formVariables.keySet());
    }

    @Override
    public String replaceFormVariables(String value, ReplacementMode replacementMode, VariableErrorHandlingDescriptor errorHandlingDescriptor) throws UndefinedVariableException {
        String formVariablesReplacedText = this.replaceFormVariablesOnly(value, errorHandlingDescriptor);
        return InstallerVariables.replaceVariables(formVariablesReplacedText, replacementMode, errorHandlingDescriptor);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public String replaceFormVariablesOnly(String value, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
        if (value == null) {
            return null;
        }
        return StringUtil.replaceVariable(value, "${form:", "}", (token, memento, hasFallback) -> {
            String value1 = this.getStringFormVariable(token);
            if (value1 == null) {
                return InstallerVariables.handleError("form variable", "form:" + token, token, variableErrorHandlingDescriptor.getFormVariables());
            }
            return value1;
        });
    }

    private String getStringFormVariable(String variableName) {
        Object value = this.getFormVariable(variableName);
        return value == null ? null : value.toString();
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    private boolean makeParentGroupVisible(FormComponent formComponent, List<?> components) {
        for (Object bean : components) {
            if (bean instanceof LayoutGroup) {
                LayoutGroupImpl layoutGroup = (LayoutGroupImpl)bean;
                boolean found = this.makeParentGroupVisible(formComponent, layoutGroup.getChildren());
                if (found && layoutGroup.getGroupType() == GroupType.SINGLE_TAB) {
                    ((TabGroup)layoutGroup.getGroup()).makeTabVisible();
                }
                if (!found) continue;
                return true;
            }
            if (bean != formComponent) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        return this.formPanel.handleConsole(console);
    }

    public void setReplacementRecording(List<String> replacementRecording) {
        this.replacementRecording = replacementRecording;
    }

    protected int getIndex(Object[] items, Object target) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != target && !items[i].equals(target)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getVariable(String variableName) {
        return this.getFormVariable(variableName);
    }

    @Override
    public String replaceVariables(String content, ReplacementMode replacementMode, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
        return this.replaceFormVariables(content, replacementMode, variableErrorHandlingDescriptor);
    }
}

