/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.LauncherSetup;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.DirectOutputRedirection;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.Document;

public abstract class AbstractControlServiceAction
extends SystemInstallOrUninstallAction {
    protected static final String METHOD_START = "start";
    protected static final String METHOD_STOP = "stop";
    private File executable;
    private String serviceName;
    private String launcherId = "";
    private Boolean previouslyRunning;
    private boolean success;
    private boolean directControlOnly;

    public String getLauncherId() {
        return AbstractControlServiceAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public File getExecutable() {
        return this.replaceWithTextOverride("executable", AbstractControlServiceAction.replaceVariables(this.executable), File.class);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String getServiceName() {
        return AbstractControlServiceAction.replaceVariables(AbstractControlServiceAction.replaceVariables(this.serviceName));
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected boolean controlService(Context context, String method) {
        return this.controlService(context, method, false);
    }

    protected boolean controlService(Context context, String method, boolean autostartOnly) {
        this.directControlOnly = false;
        this.previouslyRunning = null;
        this.success = false;
        this.success = this.controlServiceInt(context, method, autostartOnly);
        Logger.getInstance().info(this, "previous state " + this.getPreviouslyRunning());
        return this.success;
    }

    private boolean controlServiceInt(Context context, String method, boolean autostartOnly) {
        Integer returnValue;
        File usedExecutable;
        String usedName;
        if (this.getLauncherId() == null) {
            usedName = this.getServiceName();
            usedExecutable = context.getDestinationFile(this.getExecutable());
        } else {
            LauncherSetup launcherSetup = context.getLauncherById(this.getLauncherId());
            if (launcherSetup == null) {
                Logger.getInstance().log(this, "The launcher with ID " + this.getLauncherId() + " cannot be found", false);
                return false;
            }
            usedExecutable = context.getDestinationFile(launcherSetup.getRelativeFileName());
            usedName = launcherSetup.getName();
        }
        if (InstallerUtil.isWindows() && autostartOnly) {
            try {
                if (Win32Services.getStartType(usedName) != 2) {
                    return true;
                }
            }
            catch (Win32Services.ServiceException e) {
                Logger.getInstance().log(e);
            }
        }
        Logger.getInstance().info(this, "usedExecutable: " + usedExecutable);
        if (Util.isWindows()) {
            try {
                return this.executeWindows(context, method, usedName);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!usedExecutable.exists()) {
            Logger.getInstance().log(this, "The executable " + usedExecutable + " does not exist", false);
            return false;
        }
        if (Util.isMacOS()) {
            String usedIdentifier;
            String identifier = this.findIdentifier(usedExecutable, autostartOnly);
            Logger.getInstance().log(this, "macOS identifier: " + identifier, true);
            if (identifier != null) {
                this.previouslyRunning = AbstractControlServiceAction.isRunningOnMac(identifier);
            }
            String string = usedIdentifier = Objects.equals(method, METHOD_STOP) ? null : identifier;
            if (usedIdentifier != null) {
                if (!usedIdentifier.isEmpty()) {
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
                    Integer returnValue2 = LaunchHelper.launchApplication(launchDescriptor.arguments("load", new File("/Library/LaunchDaemons", usedIdentifier + ".plist").getAbsolutePath()));
                    if (returnValue2 != null && returnValue2 == 0) {
                        returnValue2 = LaunchHelper.launchApplication(launchDescriptor.arguments(method, usedIdentifier));
                        return returnValue2 != null && returnValue2 == 0;
                    }
                    return false;
                }
                return true;
            }
            Integer returnValue3 = LaunchHelper.launchApplication(new LaunchDescriptor(usedExecutable).arguments(method).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true));
            return returnValue3 != null && returnValue3 == 0;
        }
        File systemctlFile = new File("/bin/systemctl");
        if (systemctlFile.isFile()) {
            returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments("--no-ask-password", "status", usedExecutable.getName()).wait(true).executionContext(ExecutionContext.MAXIMUM).logReturnValue(false));
            if (returnValue != null) {
                this.previouslyRunning = returnValue == 0;
            }
            if ((returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments("--no-ask-password", method, usedExecutable.getName()).wait(true).executionContext(ExecutionContext.MAXIMUM))) != null && returnValue == 0) {
                return true;
            }
            Logger.getInstance().error(this, usedExecutable + " " + method + " with systemctl returned " + returnValue);
        }
        this.directControlOnly = true;
        returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(usedExecutable).arguments(method).wait(true).executionContext(ExecutionContext.MAXIMUM));
        if (returnValue != null && returnValue == 0) {
            return true;
        }
        Logger.getInstance().info(this, usedExecutable + " " + method + " returned " + returnValue);
        return false;
    }

    private String findIdentifier(File usedExecutable, boolean autostartOnly) {
        File[] plistFiles = new File("/Library/LaunchDaemons").listFiles();
        if (plistFiles != null) {
            for (File plistFile : plistFiles) {
                try {
                    Document document = XmlHelper.parseFile(plistFile);
                    String fileName = XmlHelper.getTextValue(PlistHelper.getFirstChild(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "ProgramArguments"), "string"));
                    if (Objects.equals(usedExecutable.getCanonicalPath(), fileName)) {
                        if (autostartOnly && !Boolean.parseBoolean(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "RunAtLoad").getNodeName())) {
                            return "";
                        }
                        return XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "Label"));
                    }
                }
                catch (PlistHelper.NotFoundException document) {
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
            }
        }
        return null;
    }

    private boolean executeWindows(Context context, String method, String usedName) {
        try {
            try {
                this.previouslyRunning = Win32Services.isRunning(usedName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Objects.equals(method, METHOD_START)) {
                Win32Services.startService(usedName);
            } else {
                int minimumStopWaitTime = AbstractControlServiceAction.getMinimumWaitTime(context, this.getWindowsStopMinimumWaitTime());
                Logger.getInstance().info(this, "Stop minimum wait time: " + minimumStopWaitTime);
                Win32Services.stopService(usedName, minimumStopWaitTime);
            }
            return true;
        }
        catch (Win32Services.ServiceException e) {
            if (e.getErrorCode() == 1056) {
                Logger.getInstance().info(this, "Service '" + usedName + "' already running.");
                return true;
            }
            if (e.getErrorCode() == 1062) {
                Logger.getInstance().info(this, "Service '" + usedName + "' is not running.");
                return true;
            }
            if (e.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (e.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (e.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service '" + usedName + "' does not exist. You need to install it first.");
            } else if (e.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong.");
            } else {
                Logger.getInstance().error(this, "Service control error: " + e.getErrorCode());
            }
            return false;
        }
    }

    protected int getWindowsStopMinimumWaitTime() {
        return 30000;
    }

    protected Boolean getPreviouslyRunning() {
        return this.previouslyRunning;
    }

    protected boolean isSuccess() {
        return this.success;
    }

    protected boolean isDirectControlOnly() {
        return this.directControlOnly;
    }

    private static boolean isRunningOnMac(String identifier) {
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).arguments("list", identifier).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
        LaunchHelper.LaunchResult launchResult = LaunchHelper.launchApplicationWithResult(launchDescriptor.stdoutRedirection(new DirectOutputRedirection()));
        return launchResult != null && launchResult.getReturnCode() == 0 && launchResult.getOutput() != null && launchResult.getOutput().contains("\"PID\" = ");
    }

    public static int getMinimumWaitTime(Context context, int timeout) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceMinimumStopTimeout", timeout);
    }
}

