<?php

namespace Reviews\Filter;

use Application\Filter\FilterTrait;
use Application\InputFilter\DirectInput;
use Application\InputFilter\InputFilter;
use Interop\Container\ContainerInterface;
use Laminas\Filter\StringTrim;
use Laminas\Validator\StringLength;

/**
 * Filter to validate the body values for update description call
 */
class Description extends InputFilter implements IDescription
{
    use FilterTrait;

    /**
     * Construct the filter
     * @param ContainerInterface $services services
     * @param array|null $options
     */
    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->addBool(self::UPDATE_ORIGINAL_CHANGE_LIST);
        $this->addDescriptionFilter();
    }

    /**
     * Add a string filter for description field
     */
    private function addDescriptionFilter()
    {
        $input = new DirectInput(self::DESCRIPTION);
        $input->setRequired(true);
        $input->getFilterChain()->attach(new StringTrim());
        $input->getValidatorChain()->attach(new StringLength(['min' => 1]));
        $this->add($input);
    }
}
