<?php

namespace Projects\Validator;

use Application\Validator\AbstractValidator;
use Application\Validator\ArrayValuesValidator;
use Application\Validator\IsBool;

/**
 * Validation for the email flags array, as an array of boolean values
 */
class EmailFlags extends AbstractValidator
{
    const INVALID = 'invalid';

    protected $messageTemplates = [];

    public function __construct($options = null)
    {
        $this->messageTemplates = [
            self::INVALID => $this->tGen('Email flags should be an array of named true/false values')
        ];
        parent::__construct($options);
    }

    /**
     * Validate that all supplied values are booleans
     * @inheritDoc
     */
    public function isValid($value): bool
    {
        foreach ($value??[] as $flag => $flagValue) {
            if (!in_array($flagValue, ["0", "1"])) {
                $this->error(self::INVALID);
                return false;
            }
        }
        return true;
    }
}
