<?php

namespace Projects\Validator;

use Application\Validator\IsBool;
use Laminas\Validator\Exception;
use Laminas\Validator\StringLength;
use Projects\Model\IProject;

class Deploy extends \Application\Validator\AbstractValidator
{

    public function __construct($options = null)
    {
        $this->messageTemplates = [
            IProject::DEPLOY_URL => $this->tGen('URL for deploy to must be provided if deployment is enabled.'),
        ];
        parent::__construct($options);
    }

    /**
     * @inheritDoc
     */
    public function isValid($value)
    {
        $errors           = [];
        $enabledValidator = new IsBool();
        $urlValidator     = new StringLength(['min'=>($value[IProject::DEPLOY_ENABLED]??false)?1:0]);
        if (!$enabledValidator->isValid($value[IProject::DEPLOY_ENABLED]??false)) {
            $errors[IProject::DEPLOY_ENABLED] = $enabledValidator->getMessages();
        }
        if (!$urlValidator->isValid($value[IProject::DEPLOY_URL]??"")) {
            $errors[IProject::DEPLOY_URL] = $this->createMessage(IProject::DEPLOY_URL, $value);
        }
        if (count($errors)) {
            $this->abstractOptions['messages'] = $errors;
            return false;
        }
        return true;
    }
}
