<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */

namespace Projects\Model;

/**
 * Common definition for project attributes
 */
interface IProject
{
    const PROJECT                  = 'project';
    const ID                       = 'id';
    const NAME                     = 'name';
    const DESCRIPTION              = 'description';
    const WORKFLOW                 = 'workflow';
    const RETAIN_DEFAULT_REVIEWERS = 'retainDefaultReviewers';
    const MINIMUM_UP_VOTES         = 'minimumUpVotes';
    const MEMBERS                  = 'members';
    const SUBGROUPS                = 'subgroups';
    const BRANCH_PATHS             = 'paths';
    const BRANCHES                 = 'branches';
    const TESTS                    = 'tests';
    const PRIVATE                  = 'private';
    const DEFAULTS                 = 'defaults';
    const MODERATORS               = 'moderators';
    const MODERATORS_GROUPS        = 'moderators-groups';
    const REVIEWERS                = 'reviewers';
    const EMAIL_FLAGS              = 'emailFlags';
    const EMAIL_ON_REVIEW_UPDATE   = 'review_email_project_members';
    const EMAIL_ON_SUBMIT          = 'change_email_project_users';
    const DEPLOY                   = 'deploy';
    const DEPLOY_ENABLED           = 'enabled';
    const DEPLOY_URL               = 'url';
    const OWNERS                   = 'owners';
    const JOB_VIEW                 = 'jobview';
    const TESTS_ENABLED            = 'enabled';
    const TESTS_URL                = 'url';
    const TESTS_POST_BODY          = 'postBody';
    const TESTS_POST_FORMAT        = 'postFormat';
    const DELETED                  = 'deleted';
    const PRIVATE_PROJECTS         = 'privateProjects';
}
