<?php

namespace Projects\Filter;

use Application\Filter\FormBoolean;
use Application\Validator\FlatArray;
use Laminas\Filter\AbstractFilter;
use Projects\Model\IProject;

class Deploy extends AbstractFilter
{

    /**
     * @inheritDoc
     */
    public function filter($value)
    {
        if ((new FlatArray())->isValid($value)) {
            return [IProject::DEPLOY_ENABLED=>(new FormBoolean)->filter($value[IProject::DEPLOY_ENABLED]??false),
                IProject::DEPLOY_URL=>$value[IProject::DEPLOY_URL]??null];
        }
        return $value;
    }
}
