<?php
/**
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */
namespace Authentication\Helper;

use Application\Config\ConfigException;
use Application\Http\SwarmRequest;
use Laminas\Http\Response;

interface ILogoutHelper
{
    const HELPER_NAME            = 'logoutHelper';
    const CODE_LOGOUT_ERROR      = 'user-logout-error';
    const CODE_LOGOUT_SUCCESSFUL = 'user-logged-out';
    const TEXT_LOGOUT_SUCCESSFUL = 'Successful Logout.';
    const PARAM_REDIRECT         = 'redirect';
    const SESSION                = 'session';
    const LOG_ID                 = 'Login:Helper:self:: ';
    const URL                    = 'url';


    /**
     * Utility to handle log out for web and api controllers. Will attempt to redirect to the referrer or
     * a custom logout page unless the parameter 'redirect=false' is requested.
     * @param SwarmRequest $request current request
     * @param Response $response current response
     * @return Response
     * @throws ConfigException
     */
    public function logout(SwarmRequest $request, Response $response);
}
