<?php

namespace Projects\Validator;

use Application\Config\Services;
use Application\Validator\AbstractValidator;
use Exception;
use Projects\Checker\IProject;

class Name extends AbstractValidator
{
    const NOT_ALLOWED           = "notAllowed";
    protected $messageTemplates = [];
    const CHECK_PERMISSION      = "checkPermission";
    protected $services         = null;
    protected $checkPermission  = [];

    public function __construct($options = null)
    {
        $this->services         = $options[self::SERVICES];
        $this->checkPermission  = $options[self::CHECK_PERMISSION];
        $this->messageTemplates = [
            self::NOT_ALLOWED => $this->tGen('Only administrators can change the name of a project.')
        ];
        parent::__construct($options);
    }

    /**
     * @inheritDoc
     */
    public function isValid($value) : bool
    {
        if ($this->checkPermission) {
            try {
                $this->services->get(Services::CONFIG_CHECK)->check(IProject::PROJECT_NAME_ADMIN_ONLY_CHECKER);
            } catch (Exception $exception) {
                $this->error(self::NOT_ALLOWED);
                return false;
            }
        }
        return true;
    }
}
