<?php

namespace kornrunner\Blurhash;

use PHPUnit\Framework\TestCase;
use InvalidArgumentException;

class Base83Test extends TestCase {

    /**
     * @dataProvider data
     */
    public function testEncode ($length, $tests): void {
        foreach ($tests as $test) {
            $value = $test[0];
            $expected = $test[1];
            $this->assertEquals ($expected, Base83::encode($value, $length));
        }
    }

    public function testEncodeThrows (): void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Specified length is too short to encode given value.');
        Base83::encode (PHP_INT_MAX, 1);
    }

    /**
     * @dataProvider data
     */
    public function testDecode ($length, $tests): void {
        foreach ($tests as $test) {
            $value = $test[1];
            $expected = $test[0];
            $this->assertEquals ($expected, Base83::decode($value));
        }
    }

    public static function data(): array {
        return [
            [1, [
                [0, '0'], [1, '1'], [2, '2'], [3, '3'], [4, '4'], [5, '5'], [6, '6'], [7, '7'], [8, '8'], [9, '9'],
                [10, 'A'], [11, 'B'], [12, 'C'], [13, 'D'], [14, 'E'], [15, 'F'], [16, 'G'], [17, 'H'], [18, 'I'], [19, 'J'],
                [20, 'K'], [21, 'L'], [22, 'M'], [23, 'N'], [24, 'O'], [25, 'P'], [26, 'Q'], [27, 'R'], [28, 'S'], [29, 'T'],
                [30, 'U'], [31, 'V'], [32, 'W'], [33, 'X'], [34, 'Y'], [35, 'Z'], [36, 'a'], [37, 'b'], [38, 'c'], [39, 'd'],
                [40, 'e'], [41, 'f'], [42, 'g'], [43, 'h'], [44, 'i'], [45, 'j'], [46, 'k'], [47, 'l'], [48, 'm'], [49, 'n'],
                [50, 'o'], [51, 'p'], [52, 'q'], [53, 'r'], [54, 's'], [55, 't'], [56, 'u'], [57, 'v'], [58, 'w'], [59, 'x'],
                [60, 'y'], [61, 'z'], [62, '#'], [63, '$'], [64, '%'], [65, '*'], [66, '+'], [67, ','], [68, '-'], [69, '.'],
                [70, ':'], [71, ';'], [72, '='], [73, '?'], [74, '@'], [75, '['], [76, ']'], [77, '^'], [78, '_'], [79, '{'],
                [80, '|'], [81, '}'], [82, '~'],
            ]],
            [2, [
                [83, '10'], [84, '11'], [85, '12'], [86, '13'], [87, '14'], [88, '15'], [89, '16'],
                [90, '17'], [91, '18'], [92, '19'], [93, '1A'], [94, '1B'], [95, '1C'], [96, '1D'], [97, '1E'], [98, '1F'], [99, '1G'],
                [100, '1H'], [101, '1I'], [102, '1J'], [103, '1K'], [104, '1L'], [105, '1M'], [106, '1N'], [107, '1O'], [108, '1P'], [109, '1Q'],
                [110, '1R'], [111, '1S'], [112, '1T'], [113, '1U'], [114, '1V'], [115, '1W'], [116, '1X'], [117, '1Y'], [118, '1Z'], [119, '1a'],
                [120, '1b'], [121, '1c'], [122, '1d'], [123, '1e'], [124, '1f'], [125, '1g'], [126, '1h'], [127, '1i'], [128, '1j'], [129, '1k'],
                [130, '1l'], [131, '1m'], [132, '1n'], [133, '1o'], [134, '1p'], [135, '1q'], [136, '1r'], [137, '1s'], [138, '1t'], [139, '1u'],
                [140, '1v'], [141, '1w'], [142, '1x'], [143, '1y'], [144, '1z'], [145, '1#'], [146, '1$'], [147, '1%'], [148, '1*'], [149, '1+'],
                [150, '1,'], [151, '1-'], [152, '1.'], [153, '1:'], [154, '1;'], [155, '1='], [156, '1?'], [157, '1@'], [158, '1['], [159, '1]'],
                [160, '1^'], [161, '1_'], [162, '1{'], [163, '1|'], [164, '1}'], [165, '1~'],
                [166, '20']
            ]],
        ];
    }
}