<?php

namespace Projects\Filter;

use Application\Filter\FormBoolean;
use Laminas\Filter\AbstractFilter;
use Projects\Model\IProject;

/**
 * Adjust the email flags values to [name:("0"|"1")]
 */
class EmailFlags extends AbstractFilter
{
    /**
     * Guarantees the flags will be present and defaulted to "1"
     * @param $value
     * @return array
     */
    public function filter($value)
    {
        $boolean    = new FormBoolean([FormBoolean::FALSE_VALUE=>"0", FormBoolean::TRUE_VALUE=>"1"]);
        $normalised = [];
        foreach ([IProject::EMAIL_ON_SUBMIT,IProject::EMAIL_ON_REVIEW_UPDATE] as $key) {
            $normalised[$key] = $boolean->filter($value[$key]??true);
        }
        return $normalised;
    }
}
