<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */
namespace Projects\Checker;

use Application\Checker;

/**
 * Interface for a project checker to implement
 */
interface IProject
{
    const PROJECT_ADD             = 'projectAdd';
    const PROJECT_EDIT            = 'projectEdit';
    const PROJECT_NAME_ADMIN_ONLY = 'projectNameAdminOnly';
    const BRANCHES_ADMIN_ONLY     = 'projectBranchesAdminOnly';
    // Convenient checker names
    const PROJECT_ADD_CHECKER             = [Checker::NAME => self::PROJECT_ADD];
    const PROJECT_EDIT_CHECKER            = [Checker::NAME => self::PROJECT_EDIT];
    const PROJECT_NAME_ADMIN_ONLY_CHECKER = [Checker::NAME => self::PROJECT_NAME_ADMIN_ONLY];
    const BRANCHES_ADMIN_ONLY_CHECKER     = [Checker::NAME => self::BRANCHES_ADMIN_ONLY];
}
