<?php

namespace Application\Service;

use Application\Service\SerializeAdapter\Exception;
use ErrorException;
use Laminas\Serializer\Adapter\PhpSerialize;
use Laminas\Serializer\Exception\RuntimeException;
use Laminas\Stdlib\ErrorHandler;

class SwarmSerializer extends PhpSerialize
{
    /**
     * Serialized boolean false value
     *
     * @var null|string
     */
    protected static $serializedFalse = null;

    /**
     * Serialize using serialize()
     *
     * @param  mixed $value
     * @return string
     * @throws Exception\RuntimeException|ErrorException On serialize error
     */
    public function serialize($value)
    {
        ErrorHandler::start(E_WARNING | E_USER_WARNING);
        $ret = serialize($value);
        $err = ErrorHandler::stop();
        if ($err) {
            throw new RuntimeException('Serialization failed', 0, $err);
        }

        return $ret;
    }
}
